/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.ext;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import smartrics.rest.fitnesse.fixture.ext.PictureGenerator;
import smartrics.rest.fitnesse.fixture.ext.SlimRestFixtureWithSeq;

class MyFixtureListener
implements EventListener {
    private final SlimRestFixtureWithSeq.Model model;
    private final String picFileName;
    private final Map<String, String> attributes;

    public MyFixtureListener(String outFileName, SlimRestFixtureWithSeq.Model m, Map<String, String> attr) {
        this.model = m;
        this.attributes = attr != null ? attr : new HashMap();
        this.picFileName = outFileName;
    }

    public void tableFinished() {
        int pos = this.picFileName.lastIndexOf(".");
        String format = "svg";
        if (pos > 0) {
            format = this.picFileName.substring(pos + 1).toLowerCase();
        }
        byte[] content = PictureGenerator.generate(this.model.toString(), this.attributes, "template.svg", format);
        File f = new File(this.picFileName);
        try {
            f.createNewFile();
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Unable to create output picture file: " + f.getAbsolutePath(), e1);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e1) {
            throw new IllegalArgumentException("Unable to find output picture file: " + f.getAbsolutePath(), e1);
        }
        try {
            fos.write(content);
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Unable to write output picture file: " + f.getAbsolutePath(), e1);
        }
        try {
            fos.flush();
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("Unable to flush output picture file: " + f.getAbsolutePath());
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

