/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.util;

import java.util.Iterator;

public class LimitedIterator<T>
implements Iterator<T> {
    private final Iterator<T> it;
    private final int limit;
    private int count = 0;

    public LimitedIterator(Iterator<T> it, int limit) {
        this.it = it;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.limit && this.it.hasNext();
    }

    @Override
    public T next() {
        ++this.count;
        return this.it.next();
    }

    public boolean isLastElement() {
        return this.count == this.limit - 1;
    }

    @Override
    public void remove() {
        this.it.remove();
    }

    public String toString() {
        return "LimitedIterator limit=" + this.limit;
    }
}

