/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.svg;

import com.patternity.graphic.Rectangle;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.svg.Graphic;
import com.patternity.graphic.svg.LinkStyle;
import java.util.Map;

public class LinkRenderer {
    private final Graphic g = new Graphic();

    private Rectangle box(Object element, Map boxes) {
        Rectangle box = (Rectangle)boxes.get(element);
        return box;
    }

    public void render(Node child, Map boxes, LinkStyle style) {
        if (child.isRoot()) {
            return;
        }
        Node from = child;
        Node to = from.getParent();
        this.render(from, to, boxes, style);
    }

    public Rectangle render(Node from, Node to, Map boxes, LinkStyle style) {
        Object item = from.getElement();
        Object parent = to.getElement();
        return this.render(item, parent, boxes, style);
    }

    public Rectangle render(Object item, Object parent, Map boxes, LinkStyle style) {
        Rectangle itemBox = this.box(item, boxes);
        Rectangle parentBox = this.box(parent, boxes);
        if (itemBox == null || parentBox == null) {
            return null;
        }
        this.g.drawLink(itemBox, parentBox, style.getOrientation(), style.getShifts(), style.getMarker(), style.getStyle());
        return null;
    }

    public String getContent() {
        return this.g.toString();
    }

    public String toString() {
        return "LinkRenderer";
    }
}

