/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.svg;

import com.patternity.graphic.Orientation;
import com.patternity.graphic.Position;
import com.patternity.graphic.Rectangle;
import java.text.MessageFormat;

public class Graphic {
    private final StringBuffer out = new StringBuffer();

    public void drawRectangle(Position pos, int width, int height, String style) {
        this.drawRectangle((int)pos.getX(), (int)pos.getY(), width, height, style);
    }

    public void drawRectangle(int x, int y, int width, int height, String style) {
        this.drawRectangle(x, y, width, height, style, "");
    }

    public void drawEllipse(int x, int y, int rx, int ry, String style, String misc) {
        String pattern = "<ellipse cx=\"{0}\" cy=\"{1}\" rx=\"{2}\" ry=\"{3}\" {5} class=\"{4}\" />";
        Object[] objects = new Object[]{Integer.toString(x), Integer.toString(y), Integer.toString(rx), Integer.toString(ry), style, misc};
        String rect = MessageFormat.format("<ellipse cx=\"{0}\" cy=\"{1}\" rx=\"{2}\" ry=\"{3}\" {5} class=\"{4}\" />", objects);
        this.newline();
        this.out.append(rect);
    }

    public void drawRectangle(int x, int y, int width, int height, String style, String misc) {
        String pattern = "<rect x=\"{0}\" y=\"{1}\" width=\"{2}\" height=\"{3}\" {5} class=\"{4}\" />";
        Object[] objects = new Object[]{Integer.toString(x), Integer.toString(y), Integer.toString(width), Integer.toString(height), style, misc};
        String rect = MessageFormat.format("<rect x=\"{0}\" y=\"{1}\" width=\"{2}\" height=\"{3}\" {5} class=\"{4}\" />", objects);
        this.newline();
        this.out.append(rect);
    }

    public void drawLine(int x, int y, int x2, int y2, String style) {
        this.drawLine(x, y, x2, y2, style, "");
    }

    public void drawLine(int x, int y, int x2, int y2, String style, String misc) {
        String pattern = "<line x1=\"{0}\" y1=\"{1}\" x2=\"{2}\" y2=\"{3}\" {5} class=\"{4}\" />";
        Object[] objects = new Object[]{Integer.toString(x), Integer.toString(y), Integer.toString(x2), Integer.toString(y2), style, misc};
        String rect = MessageFormat.format("<line x1=\"{0}\" y1=\"{1}\" x2=\"{2}\" y2=\"{3}\" {5} class=\"{4}\" />", objects);
        this.newline();
        this.out.append(rect);
    }

    public void drawLink(Rectangle fromBox, Rectangle toBox, Orientation hint, Position shifts, String marker, String style) {
        if (fromBox.getPosition().equals(toBox.getPosition())) {
            this.drawLoopPath(fromBox.getPort(Orientation.EAST), shifts, marker, style);
            return;
        }
        Orientation dir = Orientation.orientation(hint, fromBox.getPosition(), toBox.getPosition());
        Position from = fromBox.getPort(dir);
        Position to = toBox.getPort(dir.opposite());
        if (shifts == null || shifts.isZero()) {
            this.drawPath(from, to, marker, style);
            return;
        }
        if (!shifts.isPositive()) {
            return;
        }
        Position transform = shifts.multiply(dir.coefficients());
        Position via1 = from.add(transform);
        Position via2 = dir instanceof Orientation.HorizontalOrientation ? new Position(via1.getX(), to.getY()) : new Position(to.getX(), via1.getY());
        String path = Graphic.moveTo(from) + " " + Graphic.lineTo(via1) + " " + Graphic.lineTo(via2) + " " + Graphic.lineTo(to);
        this.drawPath(path, marker, style);
    }

    public void drawLoopPath(Position pos, Position dimensions, String marker, String style) {
        int dx = (int)dimensions.getX();
        int dy = (int)dimensions.getY();
        String path = Graphic.moveTo(pos.add(0.0, -dy)) + " h " + dx + " v " + dy + " h -" + dx;
        this.drawPath(path, marker, style);
    }

    public static String moveTo(Position position) {
        return "M " + position.getX() + "," + position.getY();
    }

    public static String lineTo(Position position) {
        return "L " + position.getX() + "," + position.getY();
    }

    public void drawPath(Position pos1, Position pos2, String marker, String style) {
        String path = Graphic.moveTo(pos1) + " " + Graphic.lineTo(pos2);
        this.drawPath(path, marker, style);
    }

    public void drawPath(String path, String marker, String style) {
        this.drawPath(path, marker, style, "");
    }

    public void drawPath(String path, String marker, String style, String misc) {
        String pattern = "<path d=\"{0}\" marker-end=\"url(#{1})\" {3} class=\"{2}\" />";
        String link = MessageFormat.format("<path d=\"{0}\" marker-end=\"url(#{1})\" {3} class=\"{2}\" />", path, marker, style, misc);
        this.newline();
        this.out.append(link);
    }

    public void drawText(int x, int y, String method, String style) {
        this.drawText(x, y, method, style, "");
    }

    public void drawText(int x, int y, String method, String style, String misc) {
        String textPattern = "<text x=\"{0}\" y=\"{1}\" {4} class=\"{2}\">{3}</text>";
        String t = MessageFormat.format("<text x=\"{0}\" y=\"{1}\" {4} class=\"{2}\">{3}</text>", Integer.toString(x), Integer.toString(y), style, method, misc);
        this.newline();
        this.out.append(t);
    }

    public void drawNote(int x, int y, int width, int heigth, int corner, String style) {
        String start = x + width - corner + "," + y;
        String end = x + width + "," + (y + corner);
        String path = start + " " + x + "," + y + " " + x + "," + (y + heigth) + " " + (x + width) + "," + (y + heigth) + " " + end + " " + start + " " + (x + width - corner) + "," + (y + corner) + " " + end;
        String note = MessageFormat.format("<polygon points=\"{0}\" class=\"{1}\" />", path, style);
        this.newline();
        this.out.append(note);
    }

    public void drawDescription(String desc) {
        this.out.append("\n<desc>");
        this.out.append(desc);
        this.out.append("</desc>");
    }

    public void newline() {
        this.out.append("\n");
    }

    public void println(String s) {
        this.newline();
        this.out.append(s);
    }

    public String toString() {
        return this.out.toString();
    }
}

