/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.svg;

import com.patternity.graphic.BoundingBox;
import com.patternity.graphic.layout.GridLayout;
import com.patternity.graphic.layout.Layout;
import com.patternity.graphic.svg.Box;
import com.patternity.graphic.svg.BoxRenderer;
import com.patternity.graphic.svg.BoxStyle;
import com.patternity.graphic.svg.Diagram;
import com.patternity.graphic.svg.Link;
import com.patternity.graphic.svg.LinkRenderer;
import com.patternity.graphic.svg.LinkStyle;
import java.util.HashMap;

public final class DiagramRenderer {
    private final BoxRenderer boxRenderer;
    private final LinkRenderer linkRenderer;
    private final boolean linksFirst;

    public DiagramRenderer(BoundingBox grid, double paddingRatio, Layout layout, int fontsize, boolean linksFirst) {
        this(new BoxRenderer(new GridLayout(layout, grid), grid.scale(1.0 - paddingRatio), fontsize), new LinkRenderer(), linksFirst);
    }

    public DiagramRenderer(BoxRenderer boxRenderer, LinkRenderer linkRenderer, boolean linksFirst) {
        this.boxRenderer = boxRenderer;
        this.linkRenderer = linkRenderer;
        this.linksFirst = linksFirst;
    }

    public void render(Diagram diagram) {
        HashMap boxes = new HashMap();
        for (Box box : diagram.getBoxes()) {
            this.boxRenderer.render(box.getNode(), boxes, (BoxStyle)box.getStyle());
        }
        for (Link link : diagram.getLinks()) {
            this.linkRenderer.render(link.getFrom(), link.getTo(), boxes, (LinkStyle)link.getStyle());
        }
    }

    public String getContent() {
        String nodes = this.boxRenderer.getContent();
        String links = this.linkRenderer.getContent();
        String content = this.linksFirst ? links + "\n" + nodes : nodes + "\n" + links;
        return content;
    }

    public String toString() {
        return "DiagramRenderer boxRenderer: " + this.boxRenderer + " linkRenderer: " + this.linkRenderer;
    }
}

