/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.svg;

import com.patternity.graphic.dag.DepthFirstIterator;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.svg.Box;
import com.patternity.graphic.svg.BoxStyle;
import com.patternity.graphic.svg.Link;
import com.patternity.graphic.svg.LinkStyle;
import java.util.ArrayList;
import java.util.List;

public final class Diagram {
    private final List<Box> boxes = new ArrayList<Box>();
    private final List<Link> links = new ArrayList<Link>();

    public void addBox(Node node, BoxStyle style) {
        this.boxes.add(new Box(node, style));
    }

    public void addLink(Object from, Object to, LinkStyle style) {
        this.links.add(new Link(from, to, style));
    }

    public void addLinkToParent(Node node, LinkStyle style) {
        Node parent = node.getParent();
        if (parent == null) {
            return;
        }
        this.addLink(node.getElement(), parent.getElement(), style);
    }

    public void addHierarchy(Node node, BoxStyle boxStyle, LinkStyle linkStyle) {
        DepthFirstIterator it = new DepthFirstIterator(node);
        while (it.hasNext()) {
            Node n = (Node)it.next();
            this.addBox(n, boxStyle);
            this.addLinkToParent(n, linkStyle);
        }
    }

    public void addSubDiagram(Diagram subDiagram, Node to, LinkStyle linkStyle) {
        if (subDiagram.numberOfBoxes() > 0) {
            Node rootNode = subDiagram.getFirstBox().getNode();
            to.add(rootNode);
            this.addLink(rootNode.getElement(), to.getElement(), linkStyle);
            for (Box box : subDiagram.getBoxes()) {
                this.addBox(box.getNode(), (BoxStyle)box.getStyle());
            }
        }
        for (Link link : subDiagram.getLinks()) {
            this.addLink(link.getFrom(), link.getTo(), (LinkStyle)link.getStyle());
        }
    }

    public int numberOfBoxes() {
        return this.boxes.size();
    }

    public int numberOfLinks() {
        return this.links.size();
    }

    public List getBoxes() {
        return this.boxes;
    }

    public Box getFirstBox() {
        return this.boxes.isEmpty() ? null : this.boxes.get(0);
    }

    public List getLinks() {
        return this.links;
    }

    public void clear() {
        this.boxes.clear();
        this.links.clear();
    }

    public String toString() {
        return "Diagram: " + this.numberOfBoxes() + " boxes, " + this.numberOfLinks() + " links";
    }
}

