/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.svg;

import com.patternity.graphic.BoundingBox;
import com.patternity.graphic.Position;
import com.patternity.graphic.Rectangle;
import com.patternity.graphic.Text;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.layout.Layout;
import com.patternity.graphic.svg.BoxStyle;
import com.patternity.graphic.svg.Graphic;
import com.patternity.util.Named;
import java.util.Map;

public class BoxRenderer {
    private final BoundingBox cell;
    private final int fontSize;
    private final Layout layout;
    private final Graphic g = new Graphic();

    public BoxRenderer(Layout layout, BoundingBox cell, int fontSize) {
        this.layout = layout;
        this.cell = cell;
        this.fontSize = fontSize;
    }

    public String getContent() {
        return this.g.toString();
    }

    public void render(Node node, Map boxes, BoxStyle boxStyle) {
        if (boxStyle == null) {
            return;
        }
        Object item = node.getElement();
        Position pos = this.layout.position(node);
        Rectangle boundingBox = this.print(item, pos, boxStyle);
        boxes.put(item, boundingBox);
    }

    public Rectangle print(Object item, Position pos, BoxStyle boxStyle) {
        Named named = (Named)item;
        Rectangle boundingBox = boxStyle.evaluate(pos, named, this);
        return boundingBox;
    }

    protected Rectangle printPattern(Position pos, Named named) {
        Rectangle boundingBox = new Rectangle(pos, this.cell);
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        int boxWidth = this.cell.getWidth();
        int boxHeight = this.cell.getHeight();
        this.g.drawEllipse(x, y, boxWidth / 2, boxHeight / 2, "pattern", "");
        int cornerY = y - boxHeight / 2;
        int textHeight = Text.textHeight(this.fontSize);
        this.g.drawText(x, cornerY + textHeight, named.getName(), "name");
        return boundingBox;
    }

    protected Rectangle printSet(Position pos, Named named) {
        Rectangle boundingBox = new Rectangle(pos, this.cell);
        this.g.drawDescription("hidden: " + named.getName());
        boundingBox = new Rectangle(pos, 0, 0);
        return boundingBox;
    }

    protected Rectangle printNote(Position pos, Named named) {
        Rectangle boundingBox = new Rectangle(pos, this.cell);
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        int boxWidth = this.cell.getWidth();
        int boxHeight = this.cell.getHeight();
        int cornerX = x - boxWidth / 2;
        int cornerY = y - boxHeight / 2;
        this.g.drawNote(cornerX, cornerY, boxWidth, boxHeight, 15, "note");
        int textHeight = Text.textHeight(this.fontSize);
        this.g.drawText(cornerX + this.fontSize, cornerY + textHeight, named.getName(), "message");
        return boundingBox;
    }

    protected Rectangle printType(Position pos, Named named) {
        Rectangle boundingBox = new Rectangle(pos, this.cell);
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        int boxWidth = this.cell.getWidth();
        int boxHeight = this.cell.getHeight();
        Position corner = pos.add(-boxWidth / 2, -boxHeight / 2);
        this.g.drawRectangle(corner, boxWidth, boxHeight, "classbox");
        int cornerY = y - boxHeight / 2;
        int textHeight = Text.textHeight(this.fontSize);
        this.g.drawText(x, cornerY + textHeight, named.getName(), "name");
        return boundingBox;
    }

    public String toString() {
        return "BoxRenderer cell=" + this.cell + " fontsize=" + this.fontSize;
    }
}

