/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.layout.sequence;

import com.patternity.graphic.behavioral.Activation;
import com.patternity.graphic.behavioral.Agent;
import com.patternity.graphic.behavioral.Event;
import com.patternity.graphic.behavioral.Message;
import com.patternity.graphic.dag.Node;
import java.util.HashMap;
import java.util.Map;

public class SnippetGenerator {
    private final Map activations = new HashMap();

    public String layout(Node root) {
        StringBuffer out = new StringBuffer();
        this.walk(root);
        for (SnippetActivation activation : this.activations.values()) {
            out.append(activation.getBody());
        }
        String content = out.toString();
        return content;
    }

    private SnippetActivation activationFor(Agent agent) {
        SnippetActivation activation = (SnippetActivation)this.activations.get(agent);
        if (activation == null) {
            activation = new SnippetActivation(agent);
            this.activations.put(agent, activation);
        }
        return activation;
    }

    private void walk(Node node) {
        Event event = (Event)node.getElement();
        if (!(event instanceof Message)) {
            return;
        }
        Message message = (Message)event;
        Agent source = this.source(node);
        Agent target = message.getTarget();
        String method = message.getMethod();
        if (!source.isRoot()) {
            SnippetActivation activationSource = this.activationFor(source);
            activationSource.call(target, method);
        }
        SnippetActivation activation = this.activationFor(target);
        activation.enterMethod(method);
        Node[] children = node.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            this.walk(child);
        }
        activation.exitMethod();
    }

    private Agent source(Node node) {
        if (node.isRoot()) {
            return Agent.ROOT;
        }
        Message element = (Message)node.getParent().getElement();
        Agent target = element.getTarget();
        return target == null ? Agent.ROOT : target;
    }

    public String toString() {
        return "SnippetGenerator";
    }

    public static class SnippetActivation
    extends Activation {
        private final Map methodBodies = new HashMap();

        public SnippetActivation(Agent agent) {
            super(agent);
        }

        private StringBuffer bodyFor(String method) {
            StringBuffer body = (StringBuffer)this.methodBodies.get(method);
            if (body == null) {
                body = new StringBuffer();
                this.methodBodies.put(method, body);
            }
            return body;
        }

        private void openBody(String method) {
            StringBuffer body = this.bodyFor(method);
            body.append("\n  public void " + method + " {");
            body.append("\n    //...");
        }

        private void closeBody(String method) {
            StringBuffer body = this.bodyFor(method);
            body.append("\n  }");
        }

        @Override
        public void enterMethod(String method) {
            this.openBody(method);
            super.enterMethod(method);
        }

        public void call(Agent target, String method) {
            String currentMethod = this.currentMethod();
            StringBuffer body = this.bodyFor(currentMethod);
            if (target.equals(this.agent)) {
                body.append("\n    " + method);
            } else {
                body.append("\n    " + target.getName() + "." + method);
            }
            body.append(";");
        }

        @Override
        public Object exitMethod() {
            String method = (String)super.exitMethod();
            this.closeBody(method);
            return method;
        }

        public String getBody() {
            StringBuffer out = new StringBuffer();
            String type = this.agent.getType() == null ? "Example" : this.agent.getType();
            out.append("\n// " + type + ".java");
            out.append("\n\npublic class " + type + " {");
            out.append("\n  //...");
            for (StringBuffer body : this.methodBodies.values()) {
                out.append("\n");
                out.append(body.toString());
            }
            out.append("\n}\n");
            return out.toString();
        }

        @Override
        public String toString() {
            return "Snippet " + super.toString();
        }
    }
}

