/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.layout;

import com.patternity.graphic.Position;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.layout.Layout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HierarchyLayout
implements Layout {
    public Map layout(Iterator iterator) {
        HashMap<Object, Position> positions = new HashMap<Object, Position>();
        int i = 0;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Position position = this.position(node);
            positions.put(node.getElement(), position);
            ++i;
        }
        return positions;
    }

    @Override
    public Position position(Node node) {
        int column = HierarchyLayout.column(node);
        double widthExcess = node.getMaxBreadth() - 1;
        double halfSpanWidth = widthExcess / 2.0;
        double x = halfSpanWidth + (double)column;
        double y = node.getDepth() - 1;
        Position position = new Position(x, y);
        return position;
    }

    private static int column(Node node) {
        if (node.isRoot()) {
            return 0;
        }
        Node previous = node.getPrevious();
        if (previous != null) {
            return HierarchyLayout.column(previous) + previous.getMaxBreadth();
        }
        return HierarchyLayout.column(node.getParent());
    }

    public String toString() {
        return "HierarchyLayout";
    }
}

