/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.layout;

import com.patternity.graphic.BoundingBox;
import com.patternity.graphic.Position;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.layout.Layout;

public class GridLayout
implements Layout {
    private static final Position CENTER = new Position(0.5, 0.5);
    private final Layout layout;
    private final BoundingBox grid;
    private final Position flip;
    private final boolean tranpose;
    private final Position origin;
    private final Position scale;

    public static final GridLayout gridLR(Layout layout, BoundingBox grid) {
        return GridLayout.gridLR(layout, grid, null);
    }

    public static final GridLayout gridLR(Layout layout, BoundingBox grid, Position origin) {
        return new GridLayout(layout, grid, Position.IDENTITY, false, origin);
    }

    public static final GridLayout gridTB(Layout layout, BoundingBox grid) {
        return GridLayout.gridTB(layout, grid, null);
    }

    public static final GridLayout gridTB(Layout layout, BoundingBox grid, Position origin) {
        return new GridLayout(layout, grid.transpose(), Position.IDENTITY, true, origin);
    }

    public GridLayout(Layout layout, BoundingBox grid) {
        this(layout, grid, Position.IDENTITY, false, null);
    }

    public GridLayout(Layout layout, BoundingBox grid, Position flip, boolean tranpose, Position origin) {
        this.layout = layout;
        this.grid = grid;
        this.flip = flip;
        this.tranpose = tranpose;
        this.origin = origin;
        this.scale = grid == null ? flip : flip.multiply(grid.getWidth(), grid.getHeight());
    }

    @Override
    public Position position(Node node) {
        Position position = this.layout.position(node);
        position = position.add(CENTER);
        position = position.multiply(this.scale);
        if (this.tranpose) {
            position = position.transpose();
        }
        if (this.origin != null) {
            position = position.add(this.origin);
        }
        return position;
    }

    public String toString() {
        return "GridLayout grid=" + this.grid + " on " + this.layout;
    }
}

