/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.dag;

import com.patternity.graphic.dag.Node;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.collections.iterators.SingletonIterator;

public class DepthFirstIterator
implements Iterator {
    private final Stack stack = new Stack();

    public DepthFirstIterator(Node root) {
        SingletonIterator iterator = new SingletonIterator((Object)root);
        this.stack.push(iterator);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty() && this.currentIterator().hasNext();
    }

    private Iterator currentIterator() {
        Iterator it = (Iterator)this.stack.peek();
        return it;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element in node tree");
        }
        Iterator current = this.currentIterator();
        Node node = (Node)current.next();
        if (!current.hasNext()) {
            this.stack.pop();
        }
        if (node.size() > 0) {
            this.stack.push(node.nodes());
        }
        return node;
    }

    @Override
    public void remove() {
        this.currentIterator().remove();
    }

    public String toString() {
        return "DepthFirstIterator";
    }
}

