/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.behavioral;

import com.patternity.graphic.behavioral.Agent;
import com.patternity.graphic.behavioral.Message;
import com.patternity.graphic.behavioral.MultipleDelegation;
import com.patternity.graphic.behavioral.Note;
import com.patternity.graphic.dag.Node;
import java.text.MessageFormat;

public class Composite
extends MultipleDelegation {
    public static final String SELF_ASSIGNMENT_DESC = "Call each child.{1} until the work is handled";
    public static final String SHARED_EFFORT_DESC = "Always call each child.{1}";

    public static final Composite newCompositeSharedEffort(Message genericEvent) {
        return Composite.newComposite(genericEvent, SHARED_EFFORT_DESC);
    }

    public static final Composite newCompositeSelfAssignment(Message genericEvent) {
        return Composite.newComposite(genericEvent, SELF_ASSIGNMENT_DESC);
    }

    public static final Composite newComposite(Message genericEvent, String commentPattern) {
        Agent[] children = genericEvent.getTarget().agents1_N(4);
        String method = genericEvent.getMethod();
        boolean enableEllipsis = true;
        String comment = MessageFormat.format(commentPattern, children[0].getName(), method);
        return new Composite(children, method, true, comment);
    }

    public static final Composite newComposite(Message genericEvent, String commentPattern, int n) {
        Agent[] children = genericEvent.getTarget().agents1_N(n);
        String method = genericEvent.getMethod();
        boolean enableEllipsis = n > 2;
        String comment = MessageFormat.format(commentPattern, children[0].getName(), method);
        return new Composite(children, method, enableEllipsis, comment);
    }

    public Composite(Agent[] children, String method, boolean enableEllipsis, String comment) {
        super(method, children, comment, enableEllipsis);
    }

    @Override
    public void append(Node compositeNode) {
        String note = this.comment == null ? "..." : this.comment;
        for (int i = 0; i < this.children.length; ++i) {
            boolean lastBut1 = this.enableEllipsis && i == this.children.length - 2;
            this.children[i] = lastBut1 ? Agent.ELLIPSIS : this.children[i];
            Agent child = this.children[i];
            if (lastBut1) {
                compositeNode.add(new Node(new Note(child, note)));
                continue;
            }
            compositeNode.add(new Node(new Message(child, this.method)));
        }
    }

    @Override
    public String toString() {
        return "Composite " + this.describe();
    }
}

