/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.behavioral;

public class Agent {
    private static final String[] NO_STEREOTYPE = new String[0];
    private final String name;
    private final String type;
    private final String[] stereotypes;
    private final boolean isActivable;
    public static final Agent ROOT = new Agent(null, null, false, new String[]{"ROOT"});
    public static final Agent ALL = new Agent(null, null, false, new String[]{"ALL"});
    public static final Agent ELLIPSIS = new Agent("...", null, false, new String[]{"ELLIPSIS"});

    public Agent[] agents1_N(int n) {
        Agent[] agents = new Agent[n];
        for (int i = 0; i < n; ++i) {
            Agent agent;
            String index = i == n - 1 ? "N" : String.valueOf(i + 1);
            agents[i] = agent = new Agent(this.type, this.name + " " + index, true);
        }
        return agents;
    }

    public Agent(String type, String name) {
        this(type, name, true, NO_STEREOTYPE);
    }

    public Agent(String type, String name, boolean isActivable) {
        this(type, name, isActivable, NO_STEREOTYPE);
    }

    public Agent(String type, String name, boolean isActivable, String[] stereotypes) {
        this.type = type == null ? "" : type;
        this.name = name == null ? "" : name;
        this.stereotypes = stereotypes;
        this.isActivable = isActivable;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String[] getStereotypes() {
        return this.stereotypes;
    }

    public boolean isActivable() {
        return this.isActivable;
    }

    public boolean hasLifeline() {
        return !this.isRoot() && !this.isEllipsis();
    }

    public boolean isEllipsis() {
        return this == ELLIPSIS;
    }

    public boolean isAll() {
        return this == ALL;
    }

    public boolean isRoot() {
        return this == ROOT;
    }

    public boolean isRegular() {
        return this != ROOT && this != ALL;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Agent)) {
            return false;
        }
        Agent other = (Agent)arg0;
        if (this == other) {
            return true;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.isEllipsis() ? "..." : this.name + ":" + this.type;
    }
}

