/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic;

public class BoundingBox {
    private final int width;
    private final int height;
    public static final BoundingBox NONE = new BoundingBox(0, 0);

    public BoundingBox(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isZero() {
        return this.width == 0 && this.height == 0;
    }

    public boolean isPositive() {
        return this.width > 0 && this.height > 0;
    }

    public BoundingBox transpose() {
        return new BoundingBox(this.height, this.width);
    }

    public BoundingBox scale(double ratio) {
        return new BoundingBox((int)((double)this.height * ratio), (int)((double)this.width * ratio));
    }

    public String toString() {
        return "width=" + this.getWidth() + " height=" + this.getHeight();
    }
}

