/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.documentation.graphic.layout;

import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.Item;
import com.patternity.core.metamodel.PatternOccurrence;
import com.patternity.core.metamodel.Relation;
import com.patternity.core.metamodel.Role;
import com.patternity.documentation.graphic.layout.BinaryRelation;
import com.patternity.graphic.dag.BreadthFirstIterator;
import com.patternity.graphic.dag.DepthFirstIterator;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.dag.NodeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;

public class Hierarchy {
    private final NodeBuilder builder;
    private final String name;
    private final List relations = new ArrayList();

    public Hierarchy() {
        this(null);
    }

    public Hierarchy(String name) {
        this.name = name;
        this.builder = new NodeBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Node getRootNode() {
        return this.builder.getRootNode();
    }

    public void add(Element parent, Element child) {
        this.add(parent, child, Relation.INHERITANCE_RELATION.getKind());
    }

    public void add(Element parent, Element child, String kind) {
        this.builder.add(parent, child);
        if (parent != null && child != null) {
            if (kind.equalsIgnoreCase("INHERITANCE")) {
                this.addRelation(new BinaryRelation(kind, parent, child));
            } else {
                this.addRelation(new BinaryRelation(kind, child, parent));
            }
        }
    }

    public void addRelation(BinaryRelation relation) {
        this.relations.add(relation);
    }

    private static final BinaryRelation toBinaryRelation(Element element) {
        if (element instanceof PatternOccurrence) {
            PatternOccurrence occurrence = (PatternOccurrence)element;
            if (!occurrence.isRelationOccurrence()) {
                return null;
            }
            Relation relation = (Relation)occurrence.getPattern();
            String kind = relation.getKind();
            Element source = occurrence.get("Source");
            Element target = occurrence.get("Target");
            if (source == null || target == null) {
                return null;
            }
            return new BinaryRelation(kind, target, source);
        }
        return null;
    }

    public void addElement(Element element) {
        this.addElement(element, null);
    }

    public void addElement(Element element, Element parent) {
        this.addElement(element, Relation.COLLABORATION_RELATION.getKind(), parent);
    }

    public void addElement(Element element, String kind, Element parent) {
        this.addElement(element, kind, parent, false);
    }

    public void addElement(Element element, String kind, Element parent, boolean transparent) {
        BinaryRelation binaryRelation = Hierarchy.toBinaryRelation(element);
        if (binaryRelation != null) {
            this.addRelation(binaryRelation);
            return;
        }
        if (element instanceof Item) {
            Item item = (Item)element;
            this.add(parent, item, kind);
            return;
        }
        if (element instanceof PatternOccurrence) {
            PatternOccurrence occurrence = (PatternOccurrence)element;
            if (occurrence.isHierarchyOccurrence()) {
                Hierarchy hierarchy = this.newHierarchy(occurrence);
                this.addHierarchy(parent, hierarchy, Relation.COLLABORATION_RELATION.getKind());
            } else {
                this.addCompound(occurrence, kind, parent, transparent);
            }
        }
    }

    private Hierarchy newHierarchy(PatternOccurrence occurrence) {
        Hierarchy hierarchy = new Hierarchy();
        for (Element element : occurrence.getCollection("Relation")) {
            BinaryRelation binaryRelation = Hierarchy.toBinaryRelation(element);
            if (binaryRelation == null) continue;
            hierarchy.add(binaryRelation.getSource(), binaryRelation.getTarget(), binaryRelation.getKind());
        }
        return hierarchy;
    }

    public void addCompound(PatternOccurrence occurrence, String kind, Element parent, boolean transparent) {
        if (!transparent) {
            this.add(parent, occurrence, Relation.COLLABORATION_RELATION.getKind());
        }
        for (Role role : occurrence.allRoles()) {
            Element element = role.getElement();
            if (!transparent) {
                this.addElement(element, Relation.COLLABORATION_RELATION.getKind(), occurrence, false);
                continue;
            }
            this.addElement(element, kind, parent, transparent);
        }
    }

    public void addAllElements(Collection elements) {
        for (Element element : elements) {
            this.addElement(element);
        }
    }

    public void addHierarchy(Element parent, Hierarchy hierarchy, String kind) {
        Iterator it = hierarchy.dfsIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.isRoot()) {
                Element root = (Element)node.getElement();
                this.builder.add(parent, root);
                this.addRelation(new BinaryRelation(kind, root, parent));
                continue;
            }
            this.builder.add((Element)node.getParent().getElement(), (Element)node.getElement());
        }
        this.addAllRelations(hierarchy.getRelations());
    }

    private void addAllRelations(Collection relations) {
        for (BinaryRelation relation : relations) {
            this.addRelation(relation);
        }
    }

    public Element getRootElement() {
        return (Element)this.getRootNode().getElement();
    }

    public Collection getRelations() {
        return this.relations;
    }

    public Iterator dfsIterator() {
        return new DepthFirstIterator(this.getRootNode());
    }

    public Iterator leaves() {
        return new FilterIterator(this.dfsIterator(), new Predicate(){

            public boolean evaluate(Object arg0) {
                Node node = (Node)arg0;
                return node.isLeaf();
            }
        });
    }

    public Iterator bfsIterator() {
        return new BreadthFirstIterator(this.getRootNode());
    }

    public String toString() {
        return "Hierarchy root=" + this.getRootElement();
    }
}

