/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.documentation.graphic.layout;

import com.patternity.core.metamodel.Definition;
import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.ElementReference;
import com.patternity.core.metamodel.LayeredOccurrence;
import com.patternity.core.metamodel.Note;
import com.patternity.core.metamodel.OccurrenceTemplate;
import com.patternity.core.metamodel.PatternOccurrence;
import com.patternity.core.metamodel.Relation;
import com.patternity.core.metamodel.TextTemplate;
import com.patternity.core.metamodel.Type;
import com.patternity.documentation.graphic.layout.ClassDiagramPrinter;
import com.patternity.documentation.graphic.layout.SequenceDiagramPrinter;
import com.patternity.util.Named;
import com.patternity.util.SimpleTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DiagramPrinter {
    public static Map subTypesHorribleHack;

    public static void process(File baseDir, LayeredOccurrence occurrence) {
        OccurrenceTemplate metaLayer = occurrence.metaLayer();
        for (String roleName : metaLayer.roleNameSet()) {
            Element element = metaLayer.get(roleName);
            if (!(element instanceof OccurrenceTemplate)) continue;
            OccurrenceTemplate template = (OccurrenceTemplate)element;
            DiagramPrinter.printDiagram(baseDir, template, occurrence);
        }
    }

    private static void printDiagram(File baseDir, OccurrenceTemplate flowLayer, LayeredOccurrence occurrence) {
        TextTemplate optionsTemplate = (TextTemplate)flowLayer.get("Options");
        String options = optionsTemplate.getText();
        Element[] orderedElements = flowLayer.orderedElements();
        OccurrenceTemplate shallow = occurrence.shallowLayer();
        PatternOccurrence deep = occurrence.deepLayer();
        if (options.startsWith("class-diagram")) {
            new ClassDiagramPrinter(baseDir).printDiagram(orderedElements, shallow, deep);
        } else if (options.startsWith("sequence-diagram")) {
            SequenceDiagramPrinter.printDiagram(baseDir, orderedElements, shallow, deep);
        }
    }

    public static List strip(Element element) {
        if (element instanceof PatternOccurrence) {
            PatternOccurrence occ = (PatternOccurrence)element;
            if (occ.isSetOccurrence()) {
                return occ.allElements();
            }
            if (occ.isHierarchyOccurrence()) {
                return new ArrayList(occ.getCollection("Top"));
            }
        }
        return Collections.singletonList(element);
    }

    public static Element join(List list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (Element)list.get(0);
        }
        return PatternOccurrence.newSetOccurrence(list);
    }

    public static Element evaluateDefinition(Element rawElement, OccurrenceTemplate shallow, PatternOccurrence deep) {
        if (!(rawElement instanceof Definition)) {
            return rawElement;
        }
        if (rawElement instanceof OccurrenceTemplate) {
            OccurrenceTemplate template = (OccurrenceTemplate)rawElement;
            if (template.isHierarchyOccurrence()) {
                return DiagramPrinter.evaluateHierarchy(template, deep, shallow);
            }
            return DiagramPrinter.evaluateTemplate(template, deep, shallow);
        }
        if (rawElement instanceof ElementReference) {
            ElementReference ref = (ElementReference)rawElement;
            return DiagramPrinter.evaluateReference(ref, deep, shallow);
        }
        if (rawElement instanceof TextTemplate) {
            TextTemplate text = (TextTemplate)rawElement;
            return DiagramPrinter.evaluateText(text, deep, shallow);
        }
        throw new IllegalArgumentException("Could not resolve: " + rawElement);
    }

    private static Element evaluateHierarchy(OccurrenceTemplate template, PatternOccurrence deep, OccurrenceTemplate shallow) {
        Element rawTopElement = template.get("Target");
        Element superType = DiagramPrinter.evaluateDefinition(rawTopElement, shallow, deep);
        Iterator it = DiagramPrinter.strip(superType).iterator();
        ArrayList<Element> list = new ArrayList<Element>();
        while (it.hasNext()) {
            Element eachTarget = (Element)it.next();
            if (eachTarget == null || !(eachTarget instanceof Type)) {
                throw new IllegalArgumentException("Could not resolve Reference to top of Hierarchy: " + template);
            }
            Element hierarchyOccurrence = DiagramPrinter.toHierarchyOccurrence(eachTarget);
            list.add(hierarchyOccurrence);
        }
        return DiagramPrinter.join(list);
    }

    protected static Element toHierarchyOccurrence(Element superType) {
        PatternOccurrence hierarchy = PatternOccurrence.newHierarchyOccurrence();
        hierarchy.add(superType, Relation.INHERITANCE_RELATION, null);
        hierarchy.add("Top", superType);
        Type[] subTypes = (Type[])subTypesHorribleHack.get(superType);
        for (int i = 0; i < subTypes.length; ++i) {
            hierarchy.add(superType, Relation.INHERITANCE_RELATION, subTypes[i]);
        }
        return hierarchy;
    }

    private static Element evaluateText(TextTemplate text, final PatternOccurrence deep, final OccurrenceTemplate shallow) {
        SimpleTemplate template = new SimpleTemplate(null){

            @Override
            protected String evaluate(String variable) {
                String rolename = variable;
                Element resolved = deep.get(rolename);
                if (resolved != null) {
                    return this.print(resolved);
                }
                Element element = resolved = shallow == null ? null : shallow.get(rolename);
                if (resolved != null) {
                    return this.print(resolved);
                }
                return variable;
            }

            private final String print(Element element) {
                if (element instanceof Note) {
                    Note note = (Note)element;
                    return note.getText();
                }
                if (element instanceof Named) {
                    Named named = (Named)((Object)element);
                    return named.getName();
                }
                return null;
            }
        };
        String evaluatedText = template.process(text.getText());
        return new Note(evaluatedText);
    }

    private static PatternOccurrence evaluateTemplate(OccurrenceTemplate template, PatternOccurrence deep, OccurrenceTemplate shallow) {
        Iterator it = template.roleNameSet().iterator();
        PatternOccurrence occurrence = new PatternOccurrence(template.getPattern());
        while (it.hasNext()) {
            String roleName = (String)it.next();
            Element rawElement = template.get(roleName);
            Element resolved = DiagramPrinter.evaluateDefinition(rawElement, shallow, deep);
            if (resolved == null) continue;
            occurrence.add(roleName, resolved);
        }
        return occurrence;
    }

    private static Element evaluateReference(ElementReference ref, PatternOccurrence deep, OccurrenceTemplate shallow) {
        String rolename = ref.getRolename();
        if (rolename.equalsIgnoreCase("Self")) {
            return deep;
        }
        Element resolved = deep.get(rolename);
        if (resolved != null) {
            return resolved;
        }
        Element rawShallowElement = shallow == null ? null : shallow.get(rolename);
        resolved = DiagramPrinter.evaluateDefinition(rawShallowElement, shallow, deep);
        if (resolved != null) {
            return resolved;
        }
        throw new IllegalArgumentException("Could not resolve Reference: " + rolename);
    }
}

