/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.core.metamodel;

import com.patternity.core.metamodel.Element;
import com.patternity.util.Named;

public class Role
implements Named {
    private static final String UNNAMED = "?";
    public static final String SOURCE = "Source";
    public static final String TARGET = "Target";
    public static final String ELEMENT = "Element";
    public static final String RELATION = "Relation";
    private final String name;
    private final Element element;

    public Role(Element element) {
        this(null, element);
    }

    public Role(String name, Element element) {
        String string = this.name = name == null ? UNNAMED : name;
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null in role " + this.name);
        }
        this.element = element;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Element getElement() {
        return this.element;
    }

    public boolean isUnnamed() {
        return this.name == UNNAMED;
    }

    public boolean sharesNameWith(Named named) {
        return named != null && named.getName().equalsIgnoreCase(this.name);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Role)) {
            return false;
        }
        Role other = (Role)arg0;
        if (this == other) {
            return true;
        }
        return this.sharesNameWith(other) && other.element.equals(this.element);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.element.hashCode();
    }

    public String toString() {
        return "Role " + this.getName() + " => " + this.getElement();
    }
}

