/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.core.metamodel;

import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.Pattern;
import com.patternity.core.metamodel.Relation;
import com.patternity.core.metamodel.Role;
import com.patternity.util.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

public class PatternOccurrence
implements Element,
Named {
    private final Pattern pattern;
    private final MultiMap members = new MultiHashMap();
    public static final Pattern SET_PATTERN = new Pattern(){

        @Override
        public String getName() {
            return "Set";
        }

        public String toString() {
            return this.getName();
        }
    };
    public static final Pattern HIERARCHY_PATTERN = new Pattern(){

        @Override
        public String getName() {
            return "Hierarchy";
        }

        public String toString() {
            return this.getName();
        }
    };

    private static final Element toElement(Collection elements, boolean forceSet) {
        if (forceSet) {
            return PatternOccurrence.newSetOccurrence(elements);
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return (Element)elements.iterator().next();
        }
        return PatternOccurrence.newSetOccurrence(elements);
    }

    public static final PatternOccurrence newHierarchyOccurrence() {
        return new PatternOccurrence(HIERARCHY_PATTERN);
    }

    public static final PatternOccurrence newSetOccurrence(Collection elements) {
        if (elements == null) {
            return null;
        }
        PatternOccurrence occ = new PatternOccurrence(SET_PATTERN);
        for (Object next : elements) {
            if (next instanceof Element) {
                Element element = (Element)next;
                occ.add("Element", element);
                continue;
            }
            if (!(next instanceof Role)) continue;
            Role role = (Role)next;
            occ.add(role);
        }
        return occ;
    }

    public boolean isRelationOccurrence() {
        return this.getPattern() instanceof Relation;
    }

    public boolean isSetOccurrence() {
        return this.getPattern().equals(SET_PATTERN);
    }

    public boolean isHierarchyOccurrence() {
        return this.getPattern().equals(HIERARCHY_PATTERN);
    }

    public PatternOccurrence(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getName() {
        return this.pattern.getName();
    }

    public boolean isOccurrenceOf(Pattern pattern) {
        return this.pattern.equals(pattern);
    }

    public final void add(Element element) {
        this.add(new Role(element));
    }

    public final void add(String roleName, Element element) {
        this.add(new Role(roleName, element));
    }

    public void add(Element element, Relation kind, Element parent) {
        this.add("Element", element, "Relation", kind, parent);
    }

    public void add(String roleName, Element element, String relationRoleName, Relation kind, Element parent) {
        this.add(roleName, element);
        if (parent != null && element != null && kind != null) {
            PatternOccurrence relationship = kind.newOccurrence(element, parent);
            this.add(relationRoleName, relationship);
        }
    }

    public final void add(Role named) {
        this.members.put((Object)named.getName(), (Object)named);
    }

    public final void remove(Role named) {
        this.members.remove((Object)named.getName(), (Object)named);
    }

    public List allFlatRoles() {
        return new ArrayList(this.members.values());
    }

    public List allRoles() {
        ArrayList<Role> list = new ArrayList<Role>();
        for (Map.Entry entry : this.members.entrySet()) {
            String roleName = (String)entry.getKey();
            Collection roles = (Collection)entry.getValue();
            Element element = null;
            if (roles != null && !roles.isEmpty()) {
                if (roles.size() == 1) {
                    Role role = (Role)roles.iterator().next();
                    element = role.getElement();
                } else {
                    element = PatternOccurrence.newSetOccurrence(PatternOccurrence.toElements(roles));
                }
            }
            list.add(new Role(roleName, element));
        }
        return list;
    }

    public List allElements() {
        return PatternOccurrence.toElements(this.members.values());
    }

    public static final List toElements(Collection roles) {
        if (roles == null) {
            return null;
        }
        ArrayList<Element> list = new ArrayList<Element>();
        for (Object next : roles) {
            Role role = (Role)next;
            list.add(role.getElement());
        }
        return list;
    }

    public Collection getRoles(String name) {
        Collection collection = (Collection)this.members.get((Object)name);
        return collection == null ? null : Collections.unmodifiableCollection(collection);
    }

    public Collection getCollection(String name) {
        if ("head".equalsIgnoreCase(name)) {
            return Collections.singleton(this.get("abstraction"));
        }
        return PatternOccurrence.toElements((Collection)this.members.get((Object)name));
    }

    public Element get(String name) {
        Collection elements = this.getCollection(name);
        return PatternOccurrence.toElement(elements, false);
    }

    public int numberOf(String name) {
        Collection collection = (Collection)this.members.get((Object)name);
        return collection == null ? 0 : collection.size();
    }

    public Set getNameSet() {
        return new HashSet(this.members.keySet());
    }

    public String toString() {
        return "PatternOccurrence:" + this.getPattern().getName() + ": " + this.members.size() + " roles /" + this.members.size() + " keys";
    }

    public static final String describe(Element element) {
        StringBuffer buffer = new StringBuffer();
        PatternOccurrence.describe("  ", buffer, element);
        return buffer.toString();
    }

    protected static final void describe(String indent, StringBuffer buffer, Element element) {
        buffer.append("\n");
        buffer.append(indent);
        buffer.append(element.toString());
        if (!(element instanceof PatternOccurrence)) {
            return;
        }
        PatternOccurrence occ = (PatternOccurrence)element;
        if (occ.isRelationOccurrence()) {
            return;
        }
        for (Element member : occ.allElements()) {
            PatternOccurrence.describe(indent + "  ", buffer, member);
        }
    }
}

