/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.core.metamodel;

import com.patternity.core.metamodel.Definition;
import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.ElementReference;
import com.patternity.core.metamodel.Meta;
import com.patternity.core.metamodel.Pattern;
import com.patternity.core.metamodel.PatternOccurrence;
import com.patternity.core.metamodel.Relation;
import com.patternity.core.metamodel.TextTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OccurrenceTemplate
implements Element,
Definition {
    public static final String OPTIONS = "Options";
    private static final Meta.MetaPattern ORDERED_ROLES = new Meta.MetaPattern("OrderedRoles");
    private final Pattern pattern;
    private final Map map = new HashMap();

    public OccurrenceTemplate(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Element get(Object key) {
        return (Element)this.map.get(key);
    }

    public Set roleNameSet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public Element[] orderedElements() {
        Element element;
        ArrayList<Element> list = new ArrayList<Element>();
        int i = 0;
        while ((element = this.get("" + i)) != null) {
            list.add(element);
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    public void addRole(String roleName, Element element) {
        if (element instanceof Definition) {
            this.map.put(roleName, element);
            return;
        }
        throw new IllegalArgumentException("Expected only definition elements not concrete elements, but received: " + element);
    }

    public void addTextTemplate(String roleName, String text) {
        this.addRole(roleName, new TextTemplate(text));
    }

    public boolean isRelationOccurrence() {
        return this.getPattern() instanceof Relation;
    }

    public boolean isHierarchyOccurrence() {
        return this.getPattern().equals(PatternOccurrence.HIERARCHY_PATTERN);
    }

    public void addBinaryRelation(String roleName, String sourceRef, Relation relation, String targetRef) {
        OccurrenceTemplate rel = new OccurrenceTemplate(relation);
        rel.addRole("Source", new ElementReference(sourceRef));
        rel.addRole("Target", new ElementReference(targetRef));
        this.addRole(roleName, rel);
    }

    public void addDelegationRelation(String roleName, String sourceRef, String targetRef) {
        this.addBinaryRelation(roleName, sourceRef, Relation.DELEGATION_RELATION, targetRef);
    }

    public void addCollaborationRelation(String roleName, String sourceRef, String targetRef) {
        this.addBinaryRelation(roleName, sourceRef, Relation.COLLABORATION_RELATION, targetRef);
    }

    public void addInheritanceHierarchy(String roleName, String rootRef) {
        OccurrenceTemplate rel = new OccurrenceTemplate(PatternOccurrence.HIERARCHY_PATTERN);
        rel.addRole("Target", new ElementReference(rootRef));
        this.addRole(roleName, rel);
    }

    public void addMetaDescription(String roleName, Pattern metaPattern, String[] orderedRoles, String options) {
        if (!(metaPattern instanceof Meta)) {
            throw new IllegalArgumentException("The pattern must be a meta pattern");
        }
        OccurrenceTemplate rel = new OccurrenceTemplate(metaPattern);
        rel.addRole(OPTIONS, new TextTemplate(options));
        for (int i = 0; i < orderedRoles.length; ++i) {
            rel.addRole("" + i, new ElementReference(orderedRoles[i]));
        }
        this.addRole(roleName, rel);
    }

    public void addStructureFlow(String[] orderedRoles, String options) {
        this.addMetaDescription("StructureFlow", ORDERED_ROLES, orderedRoles, options);
    }

    public void addDynamics(String[] orderedRoles, String options) {
        this.addMetaDescription("Dynamics", ORDERED_ROLES, orderedRoles, options);
    }

    public Element get(String roleName) {
        return (Element)this.map.get(roleName);
    }

    public String toString() {
        return "OccurrenceTemplate " + this.getPattern();
    }
}

