/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.core.metamodel;

import com.patternity.core.metamodel.Item;
import com.patternity.core.metamodel.Modifiers;
import com.patternity.core.metamodel.Type;

public class Method
implements Item {
    private static final String UNKNOWN = "...";
    private final String args;
    private final String returnType;
    private final String name;
    private final Modifiers modifiers;
    private Type type;

    public Method() {
        this(UNKNOWN, "", null, Modifiers.SYNC);
    }

    public Method(String name) {
        this(name, null, null, Modifiers.SYNC);
    }

    public Method(String name, String args, String returnType, Modifiers modifiers) {
        this.name = name;
        this.args = args;
        this.returnType = returnType;
        this.modifiers = modifiers;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getArgs() {
        return this.args;
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isUnknown() {
        return this.name == UNKNOWN;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public boolean isAbstract() {
        return this.modifiers.isAbstract();
    }

    @Override
    public String qualifiedName() {
        return this.namespace() + "#" + this.signature();
    }

    public String namespace() {
        return this.getType() == null ? "" : this.getType().qualifiedName();
    }

    public String signature() {
        return this.getName() + "(" + this.getArgs() + ")";
    }

    public String shortSignature() {
        return this.getName() + "()";
    }

    public String toString() {
        return "Method " + this.getName();
    }
}

