/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.util;

import java.util.StringTokenizer;
import org.apache.commons.collections.Transformer;

public class SimpleTemplate {
    private final String delim;
    private final Transformer transformer;

    public SimpleTemplate(Transformer transformer) {
        this("$", transformer);
    }

    public SimpleTemplate(String delim, Transformer transformer) {
        this.delim = delim;
        this.transformer = transformer;
    }

    public String process(String template) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(template, this.delim);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String variable = this.evaluate(token);
            if (variable != null) {
                buffer.append(variable);
                continue;
            }
            buffer.append("(");
            buffer.append(token);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String evaluate(String token) {
        return (String)this.transformer.transform((Object)token);
    }

    public String toString() {
        return "SimpleTemplate using " + this.transformer + " to evaluate variables in the form: " + this.delim + "..." + this.delim;
    }
}

