/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;

public final class FileUtils {
    public static void writeFile(File file, String content) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(content);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File[] scanDirectory(File path, final String extension) {
        if (!path.isDirectory()) {
            throw new IllegalArgumentException("Expected a directory path: " + path);
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith("." + extension);
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        String[] filenames = path.list(filenameFilter);
        for (int i = 0; i < filenames.length; ++i) {
            String filename = filenames[i];
            try {
                File file = new File(path, filename);
                if (!file.exists() || !file.canRead()) continue;
                files.add(file);
                continue;
            }
            catch (RuntimeException e) {
                System.err.println("Exception while scanning file " + filename);
                e.printStackTrace();
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public static String readFile(File file) {
        if (!file.exists()) {
            return "";
        }
        try {
            return FileUtils.read(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found", e);
        }
    }

    public static String readResource(String resourceName) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        return FileUtils.read(new InputStreamReader(is));
    }

    public static String read(Reader reader) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(reader);
            String str = null;
            while ((str = in.readLine()) != null) {
                buffer.append(str);
                buffer.append(lineSep);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static void makeDirs(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("null value for directory");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + dir.getAbsolutePath());
        }
    }
}

