/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.svg;

import com.patternity.graphic.Orientation;
import com.patternity.graphic.Position;
import com.patternity.graphic.Style;

public class LinkStyle
implements Style {
    private final boolean reverse;
    private final String marker;
    private final String style;
    private final Orientation orientation;
    private final Position shifts;
    public static final Position SHIFTS = new Position(12.0, 12.0);
    public static final LinkStyle GENERALIZATION = new LinkStyle(false, "arrow", "emptyHead", SHIFTS, Orientation.NORTH);
    public static final LinkStyle SPECIALIZATION = new LinkStyle(true, "arrow", "emptyHead", SHIFTS, Orientation.NORTH);
    public static final LinkStyle ALLOCATION = new LinkStyle(false, "dasharrow", "openHead", null, null);
    public static final LinkStyle REVERSE_ALLOCATION = new LinkStyle(true, "dasharrow", "openHead", null, null);
    public static final LinkStyle DELEGATION = new LinkStyle(false, "arrow", "openHead", null, null);
    public static final LinkStyle DELEGATION_MANHATTAN = new LinkStyle(false, "arrow", "openHead", SHIFTS, Orientation.NORTH);
    public static final LinkStyle REVERSE_DELEGATION = new LinkStyle(true, "arrow", "openHead", null, Orientation.NORTH);
    public static final LinkStyle COLLABORATION = new LinkStyle(false, "dasharrow", "none", null, Orientation.NORTH);
    public static final LinkStyle RELATION = new LinkStyle(false, "dasharrow", "none", null, Orientation.NORTH);

    public LinkStyle(boolean reverse, String style, String marker, Position shifts, Orientation orientation) {
        this.reverse = reverse;
        this.style = style;
        this.marker = marker;
        this.shifts = shifts;
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public String getMarker() {
        return this.marker;
    }

    public String getStyle() {
        return this.style;
    }

    public Position getShifts() {
        return this.shifts;
    }

    public boolean isManhattan() {
        return this.shifts != null;
    }

    public LinkStyle toManhattan(Position newShifts) {
        return new LinkStyle(this.reverse, this.style, this.marker, newShifts, this.orientation);
    }

    public String toString() {
        return "LinkStyle " + (this.reverse ? "reverse" : "") + " " + this.getStyle() + " " + this.getMarker() + " " + this.getOrientation() + " " + this.getShifts();
    }
}

