/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.layout.sequence;

import com.patternity.graphic.behavioral.Activation;
import com.patternity.graphic.behavioral.Agent;
import com.patternity.graphic.behavioral.Event;
import com.patternity.graphic.behavioral.Message;
import com.patternity.graphic.behavioral.Note;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.svg.Graphic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceLayout {
    private static final int TIME_STEP = 30;
    private static final int AGENT_STEP = 200;
    private static final int HALF_ACTIVATION_WIDTH = 10;
    private static final int ACTIVATION_WIDTH = 20;
    private final int fontsize;
    private final Map xAgents = new HashMap();
    private final Map activations = new HashMap();
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    private int timeStep = 30;
    private int agentStep = 200;
    private final Graphic g = new Graphic();

    public SequenceLayout(int fontSize) {
        this.fontsize = 16;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTimeStep() {
        return this.timeStep;
    }

    public int getAgentStep() {
        return this.agentStep;
    }

    public void setAgentStep(int agentStep) {
        this.agentStep = agentStep;
    }

    public void setTimeStep(int timeStep) {
        this.timeStep = timeStep;
    }

    public String layout(Node root) {
        this.x = 0;
        this.y = this.timeStep;
        List agents = SequenceLayout.collectAgents(root);
        int totalActivationLength = (SequenceLayout.getActivationTime(root) + 2) * this.timeStep;
        this.height = totalActivationLength + 2 * this.timeStep;
        this.width = agents.size() * this.agentStep + 2 * this.timeStep;
        this.g.drawDescription("Agents and lifelines of the sequence diagram");
        this.printLifelines(agents, totalActivationLength);
        this.g.drawDescription("Messages");
        this.walk(root);
        return this.g.toString();
    }

    private void printLifelines(Collection agents, int height) {
        this.x += this.agentStep;
        for (Agent agent : agents) {
            if (agent == null) continue;
            this.xAgents.put(agent, new Integer(this.x));
            String style = "name";
            String entityLabel = agent.isEllipsis() ? "..." : agent.getName() + ":" + agent.getType();
            this.g.drawText(this.x, this.y, entityLabel, "name");
            int lifeTop = this.y + this.timeStep / 2;
            int lifeBottom = lifeTop + height;
            if (agent.hasLifeline()) {
                this.g.drawLine(this.x, lifeTop, this.x, lifeBottom, "lifeline");
            }
            this.x += this.agentStep;
        }
        this.g.newline();
    }

    private void walk(Node node) {
        Event event = (Event)node.getElement();
        if (event instanceof Message) {
            Message message = (Message)event;
            this.processMessage(node, message);
        } else if (event instanceof Note) {
            Note note = (Note)event;
            this.processNote(node, note);
        }
    }

    private void processNote(Node node, Note note) {
        Agent target = note.getTarget();
        int xNote = target.isAll() ? this.width / 2 : this.x(target);
        String label = note.getLabel();
        this.y += this.timeStep;
        if (target.isAll()) {
            this.g.drawNote(0, this.y + this.fontsize / 2, this.width, this.timeStep, 2 * this.fontsize, "classbox");
        }
        this.y += this.timeStep;
        this.g.drawText(xNote, this.y, label, "name");
        this.y += this.timeStep;
    }

    private void processMessage(Node node, Message message) {
        Agent source = this.source(node);
        Agent target = message.getTarget();
        String method = message.getMethod();
        String result = message.getResult();
        this.printMessage(source, method, target, message);
        if (target == null) {
            Node[] children = node.getNodes();
            for (int i = 0; i < children.length; ++i) {
                Node child = children[i];
                this.walk(child);
            }
            return;
        }
        Activation activation = this.activationFor(target);
        activation.enterMethod(method);
        int activationTime = SequenceLayout.getActivationTime(node) * this.timeStep;
        int x = this.x(target, activation.depth());
        if (target.isActivable()) {
            this.printActivation(x, this.y, activationTime);
        }
        Node[] children = node.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            this.walk(child);
        }
        activation.exitMethod();
        if (result != null) {
            this.printMessageResult(source, result, target, message);
        }
        this.y += this.timeStep;
    }

    protected Activation activationFor(Agent agent) {
        Activation activation = (Activation)this.activations.get(agent);
        if (activation == null) {
            activation = new Activation(agent);
            this.activations.put(agent, activation);
        }
        return activation;
    }

    public static int getActivationTime(Node node) {
        if (node.isLeaf()) {
            return 1;
        }
        int width = 0;
        Node[] children = node.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            width += 1 + SequenceLayout.getActivationTime(child) + 1;
        }
        return width;
    }

    public static List collectAgents(Node node) {
        ArrayList agents = new ArrayList();
        SequenceLayout.collectAgents(node, agents);
        return agents;
    }

    private static void collectAgents(Node node, List agents) {
        Event event = (Event)node.getElement();
        if (event.getTarget() != null && event.getTarget().isRegular() && !agents.contains(event.getTarget())) {
            agents.add(event.getTarget());
        }
        Node[] children = node.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            SequenceLayout.collectAgents(child, agents);
        }
    }

    private Agent source(Node node) {
        if (node.isRoot()) {
            return Agent.ROOT;
        }
        Event event = (Event)node.getParent().getElement();
        Agent target = event.getTarget();
        return target == null ? Agent.ROOT : target;
    }

    private int x(Agent agent, int depth) {
        Integer xEntity = (Integer)this.xAgents.get(agent);
        int x = xEntity == null ? 0 : xEntity + (depth - 1) * 10;
        return x;
    }

    private int x(Agent agent) {
        if (agent.isRoot()) {
            this.y += this.timeStep;
            return 0;
        }
        Activation activation = this.activationFor(agent);
        return this.x(agent, activation.depth());
    }

    protected void printActivation(int x, int y, int activationTime) {
        int x0 = x - 10;
        this.g.drawRectangle(x0, y, 20, activationTime, "classbox");
    }

    private void printMessage(Agent source, String method, Agent target, Message message) {
        this.y += this.timeStep;
        if (target == null || method == null) {
            return;
        }
        if (source == null) {
            this.printStraightMessage(Agent.ROOT, method, target, message);
            return;
        }
        if (target.equals(source)) {
            this.printReflectiveMessage(source, method);
        } else {
            this.printStraightMessage(source, method, target, message);
        }
    }

    private void printMessageResult(Agent source, String result, Agent target, Message message) {
        if (target == null || result == null) {
            return;
        }
        if (source == null) {
            this.printStraightMessage(target, result, Agent.ROOT, message);
            return;
        }
        if (target.equals(source)) {
            this.printReflectiveMessage(source, result);
        } else {
            this.printStraightMessage(target, result, source, message);
        }
    }

    private void printStraightMessage(Agent source, String method, Agent target, Message message) {
        int xTo;
        int xFrom = this.x(source);
        boolean forward = xFrom < (xTo = this.x(target));
        int x1 = xFrom + (forward ? 10 : -10);
        int x2 = xTo + (forward ? 0 : 20);
        String path = "M " + x1 + " " + this.y + " L " + x2 + " " + this.y;
        this.g.drawPath(path, "closedHead", message.isCreation() ? "dasharrow" : "arrow");
        int xText = x1 + (forward ? 10 : -10);
        int yText = this.y - this.fontsize / 2;
        String style = forward ? "message" : "backmessage";
        this.g.drawText(xText, yText, method, style);
    }

    private void printReflectiveMessage(Agent source, String method) {
        int x = this.x(source) + 20;
        int dx = this.fontsize * 2;
        int dy = this.fontsize / 2;
        String path = "M " + x + " " + this.y + " l " + dx + " 0 l 0 " + dy + " l -" + dx + " 0";
        this.g.drawPath(path, "closedHead", "arrow");
        int xText = x + 10 + dx;
        int yText = this.y + 12 - this.fontsize / 2;
        String style = "message";
        this.g.drawText(xText, yText, method, "message");
    }
}

