/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.dag;

import com.patternity.graphic.dag.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class NodeBuilder {
    private Node root;
    private final Map nodes = new HashMap();

    public void add(Object parent, Object child) {
        Node childNode = this.node(child);
        Node parentNode = this.node(parent);
        if (parentNode != null && childNode != null) {
            parentNode.add(childNode);
        }
    }

    private Node node(Object element) {
        if (element == null) {
            return null;
        }
        Node node = (Node)this.nodes.get(element);
        if (node == null) {
            node = new Node(element);
            this.nodes.put(element, node);
        }
        return node;
    }

    public Node getRootNode() {
        if (this.root == null) {
            for (Node node : this.nodes.values()) {
                if (!node.isRoot()) continue;
                this.root = node;
                return this.root;
            }
        }
        return this.root;
    }

    public void clear() {
        this.nodes.clear();
    }

    public boolean containsKey(Object key) {
        return this.nodes.containsKey(key);
    }

    public Set keySet() {
        return this.nodes.keySet();
    }

    public int size() {
        return this.nodes.size();
    }

    public Collection values() {
        return this.nodes.values();
    }

    public String toString() {
        return "NodeBuilder: " + this.nodes.size() + " nodes";
    }
}

