/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.dag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.EmptyIterator;

public class Node {
    private final Object element;
    private final List nodes = new ArrayList();
    private Node parent = null;

    public Node(Object element) {
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isLeaf() {
        return this.nodes.size() == 0;
    }

    public int getDepth() {
        if (this.isRoot()) {
            return 1;
        }
        return this.getParent().getDepth() + 1;
    }

    public int getFilteredDepth(Predicate filter) {
        int parentDepth = this.isRoot() ? 0 : this.getParent().getFilteredDepth(filter);
        return filter.evaluate(this.element) ? parentDepth + 1 : parentDepth;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getRank() {
        if (this.isRoot()) {
            return 0;
        }
        return this.parent.nodes.indexOf(this);
    }

    public Node getPrevious() {
        if (this.isRoot()) {
            return null;
        }
        int rank = this.getRank();
        if (rank == 0) {
            return null;
        }
        return (Node)this.parent.nodes.get(rank - 1);
    }

    public Node getNext() {
        if (this.isRoot()) {
            return null;
        }
        int rank = this.getRank();
        if (rank == this.parent.size() - 1) {
            return null;
        }
        return (Node)this.parent.nodes.get(rank + 1);
    }

    public Iterator nodes() {
        return this.isLeaf() ? EmptyIterator.INSTANCE : this.nodes.iterator();
    }

    public Node[] getNodes() {
        return this.nodes.toArray(new Node[this.nodes.size()]);
    }

    public void add(Node node) {
        this.nodes.add(node);
        node.setParent(this);
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int getMaxBreadth() {
        if (this.isLeaf()) {
            return 1;
        }
        int width = 0;
        Node[] children = this.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            width += child.getMaxBreadth();
        }
        return width;
    }

    public int getActivationLength() {
        if (this.isLeaf()) {
            return 1;
        }
        int width = 0;
        Node[] children = this.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            width += child.getMaxBreadth();
        }
        return width;
    }

    public int getMaxDepth() {
        int max = 0;
        Node[] children = this.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            max = Math.max(max, child.getMaxDepth());
        }
        return max + 1;
    }

    protected String describe(String indent) {
        StringBuffer buffer = new StringBuffer(indent + this.getElement() + " depth=" + this.getDepth() + " breadth=" + this.getMaxBreadth());
        Node[] children = this.getNodes();
        for (int i = 0; i < children.length; ++i) {
            Node child = children[i];
            buffer.append("\n" + child.describe("  " + indent));
        }
        return buffer.toString();
    }

    public String toString() {
        return this.describe("");
    }
}

