/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.dag;

import com.patternity.graphic.dag.Node;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.collections.iterators.SingletonIterator;

public class BreadthFirstIterator
implements Iterator {
    private final Buffer queue = new UnboundedFifoBuffer();

    public BreadthFirstIterator(Node root) {
        SingletonIterator iterator = new SingletonIterator((Object)root);
        this.queue.add((Object)iterator);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty() && this.currentIterator().hasNext();
    }

    private Iterator currentIterator() {
        return (Iterator)this.queue.get();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element in node tree");
        }
        Iterator current = this.currentIterator();
        Node node = (Node)current.next();
        if (node.size() > 0) {
            this.queue.add((Object)node.nodes());
        }
        if (!current.hasNext()) {
            this.queue.remove();
        }
        return node;
    }

    @Override
    public void remove() {
        this.currentIterator().remove();
    }

    public String toString() {
        return "DepthFirstIterator";
    }
}

