/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.behavioral;

import com.patternity.graphic.behavioral.Agent;
import com.patternity.graphic.behavioral.Collaboration;
import java.util.Arrays;

public abstract class MultipleDelegation
implements Collaboration {
    protected final Agent[] children;
    protected final String method;
    protected final boolean enableEllipsis;
    protected final String comment;

    public MultipleDelegation(String method, Agent[] children, String comment, boolean enableEllipsis) {
        this.method = method;
        this.children = children;
        this.comment = comment;
        this.enableEllipsis = enableEllipsis;
    }

    public Agent[] getChildren() {
        return this.children;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isEnableEllipsis() {
        return this.enableEllipsis;
    }

    public String getComment() {
        return this.comment;
    }

    protected String describe() {
        return "method: " + this.method + " on multiple agents: " + Arrays.asList(this.children) + (this.enableEllipsis ? "with ellipsis" : "no ellipsis") + " comment: " + this.comment;
    }

    public String toString() {
        String describe = this.describe();
        return "MultipleDelegation " + describe;
    }
}

