/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic.behavioral;

import com.patternity.graphic.behavioral.Agent;
import com.patternity.graphic.behavioral.Message;
import com.patternity.graphic.behavioral.MultipleDelegation;
import com.patternity.graphic.behavioral.Note;
import com.patternity.graphic.dag.Node;
import java.text.MessageFormat;

public class Chain
extends MultipleDelegation {
    public static final String SELF_ASSIGNMENT_DESC = "Forward to successor.{1} until the request is handled";
    public static final String SHARED_EFFORT_DESC = "Always call successor.{1}";

    public static final Chain newChainSharedEffort(Message genericEvent) {
        return Chain.newChain(genericEvent, SHARED_EFFORT_DESC);
    }

    public static final Chain newChainSelfAssignment(Message genericEvent) {
        return Chain.newChain(genericEvent, SELF_ASSIGNMENT_DESC);
    }

    public static final Chain newChain(Message genericEvent, String commentPattern) {
        Agent[] children = genericEvent.getTarget().agents1_N(4);
        String method = genericEvent.getMethod();
        boolean enableEllipsis = true;
        String comment = MessageFormat.format(commentPattern, children[0].getName(), method);
        return new Chain(children, method, true, comment);
    }

    public static final Chain newChain(Message genericEvent, String commentPattern, int n) {
        Agent[] children = genericEvent.getTarget().agents1_N(n);
        String method = genericEvent.getMethod();
        boolean enableEllipsis = n > 2;
        String comment = MessageFormat.format(commentPattern, children[0].getName(), method);
        return new Chain(children, method, enableEllipsis, comment);
    }

    public Chain(Agent[] children, String method, boolean enableEllipsis, String comment) {
        super(method, children, comment, enableEllipsis);
    }

    @Override
    public void append(Node initialNode) {
        Node firstNode = null;
        Node previousNode = null;
        for (int i = 0; i < this.children.length; ++i) {
            boolean last = this.enableEllipsis && i == this.children.length - 1;
            this.children[i] = last ? new Agent(this.children[i].getType(), "... ", false) : this.children[i];
            Agent child = this.children[i];
            Message event = new Message(child, this.method);
            Node node = new Node(event);
            if (firstNode == null) {
                firstNode = node;
            } else {
                previousNode.add(node);
            }
            previousNode = node;
        }
        if (firstNode == null) {
            return;
        }
        initialNode.add(firstNode);
        if (this.comment != null) {
            firstNode.add(new Node(new Note(this.comment)));
        }
    }

    @Override
    public String toString() {
        return "Chain " + this.describe();
    }
}

