/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Text {
    private final String text;
    private final int fontSize;
    private final int xSpace;
    private final int ySpace;

    public Text(String text, int fontsize) {
        this(text, fontsize, 5, true);
    }

    public Text(String text, int fontsize, int spacing, boolean center) {
        this(text, fontsize, spacing, spacing, center);
    }

    public Text(String text, int fontsize, int xSpace, int ySpace, boolean center) {
        this.text = text;
        this.fontSize = fontsize;
        this.xSpace = xSpace;
        this.ySpace = ySpace;
    }

    public int getTextWidth() {
        return Text.stringWidth(this.text, this.fontSize);
    }

    public int getWidth() {
        return this.getTextWidth() + 2 * this.xSpace;
    }

    public int getHeight() {
        return (int)((double)this.fontSize * 1.2 + (double)(2 * this.ySpace));
    }

    public static int textHeight(int fontSize) {
        return (int)((double)fontSize * 1.2 + (double)fontSize * 0.3);
    }

    public static int stringWidth(String text, int fontSize) {
        double thin = 0.5;
        double normal = 0.7;
        double thick = 0.8;
        String thinchars = "1lij|tI;:";
        double sum = 0.0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isUpperCase(ch) || ch == '<' || ch == '>') {
                sum += 0.8;
                continue;
            }
            if ("1lij|tI;:".indexOf(ch) != -1) {
                sum += 0.5;
                continue;
            }
            sum += 0.7;
        }
        return (int)Math.ceil(sum * (double)fontSize);
    }

    public static String[] wrap(String text, int length) {
        StringBuffer line = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(text, " \t\n", true);
        int lineLength = 0;
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (lineLength > length) {
                list.add(line.toString());
                lineLength = 0;
                line.setLength(0);
            }
            line.append(token);
            lineLength += token.length();
        }
        list.add(line.toString());
        return list.toArray(new String[list.size()]);
    }

    public static String escapeXml(String s) {
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quot;");
        return s;
    }

    public String toString() {
        return "TextBox text: " + this.text;
    }
}

