/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic;

import com.patternity.graphic.BoundingBox;
import com.patternity.graphic.Orientation;
import com.patternity.graphic.Position;

public class Rectangle {
    private final Position position;
    private final BoundingBox box;
    public static final Rectangle NONE = new Rectangle(Position.NONE, BoundingBox.NONE);

    public Rectangle(int x, int y, int width, int height) {
        this(new Position(x, y), width, height);
    }

    public Rectangle(Position position, int width, int height) {
        this(position, new BoundingBox(width, height));
    }

    public Rectangle(Position position, BoundingBox box) {
        this.position = position;
        this.box = box;
    }

    public Position getPosition() {
        return this.position;
    }

    public BoundingBox getBox() {
        return this.box;
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public int getWidth() {
        return this.box.getWidth();
    }

    public int getHeight() {
        return this.box.getHeight();
    }

    public Position getPort(Orientation orientation) {
        return orientation == null ? Orientation.EAST.getPort(this) : orientation.getPort(this);
    }

    public String toString() {
        return this.position + " " + this.box;
    }
}

