/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic;

public class Position {
    private final double x;
    private final double y;
    public static final Position NONE = new Position(0.0, 0.0);
    public static final Position ZERO = new Position(0.0, 0.0);
    public static final Position UNITY = new Position(1.0, 1.0);
    public static final Position IDENTITY = new Position(1.0, 1.0);
    public static final Position V_FLIP = new Position(1.0, -1.0);
    public static final Position H_FLIP = new Position(-1.0, 1.0);
    public static final Position INVERSE = new Position(-1.0, -1.0);

    public Position(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public boolean isPositive() {
        return this.x >= 0.0 && this.y >= 0.0;
    }

    public Position add(double x, double y) {
        return new Position(this.x + x, this.y + y);
    }

    public Position add(Position position) {
        return this.add(position.x, position.y);
    }

    public Position transpose() {
        return new Position(this.y, this.x);
    }

    public static Position min(Position pos1, Position pos2) {
        return new Position(Math.min(pos1.x, pos2.x), Math.min(pos1.y, pos2.y));
    }

    public static Position max(Position pos1, Position pos2) {
        return new Position(Math.max(pos1.x, pos2.x), Math.max(pos1.y, pos2.y));
    }

    public Position multiply(double xCoeff, double yCoeff) {
        return new Position(this.x * xCoeff, this.y * yCoeff);
    }

    public Position multiply(Position coeffs) {
        return this.multiply(coeffs.x, coeffs.y);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Position)) {
            return false;
        }
        Position other = (Position)arg0;
        if (this == other) {
            return true;
        }
        return other.x == this.x && other.y == this.y;
    }

    public int hashCode() {
        return (int)this.x ^ (int)this.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

