/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.graphic;

import com.patternity.graphic.Position;
import com.patternity.graphic.Rectangle;

public abstract class Orientation {
    private static final Position EAST_COEFF = new Position(1.0, 0.0);
    private static final Position WEST_COEFF = new Position(-1.0, 0.0);
    private static final Position NORTH_COEFF = new Position(0.0, -1.0);
    private static final Position SOUTH_COEFF = new Position(0.0, 1.0);
    public static Orientation EAST = new HorizontalOrientation(){

        @Override
        public Position getPort(Rectangle box) {
            return box.getPosition().add(box.getWidth() / 2, 0.0);
        }

        @Override
        public Orientation opposite() {
            return WEST;
        }

        @Override
        public Position coefficients() {
            return EAST_COEFF;
        }

        public String toString() {
            return "EAST";
        }
    };
    public static Orientation WEST = new HorizontalOrientation(){

        @Override
        public Position getPort(Rectangle box) {
            return box.getPosition().add(-box.getWidth() / 2, 0.0);
        }

        @Override
        public Orientation opposite() {
            return EAST;
        }

        @Override
        public Position coefficients() {
            return WEST_COEFF;
        }

        public String toString() {
            return "WEST";
        }
    };
    public static Orientation NORTH = new VerticalOrientation(){

        @Override
        public Position getPort(Rectangle box) {
            return box.getPosition().add(0.0, -box.getHeight() / 2);
        }

        @Override
        public Orientation opposite() {
            return SOUTH;
        }

        @Override
        public Position coefficients() {
            return NORTH_COEFF;
        }

        public String toString() {
            return "NORTH";
        }
    };
    public static Orientation SOUTH = new VerticalOrientation(){

        @Override
        public Position getPort(Rectangle box) {
            return box.getPosition().add(0.0, box.getHeight() / 2);
        }

        @Override
        public Orientation opposite() {
            return NORTH;
        }

        @Override
        public Position coefficients() {
            return SOUTH_COEFF;
        }

        public String toString() {
            return "SOUTH";
        }
    };

    public abstract Position getPort(Rectangle var1);

    public abstract Position coefficients();

    public abstract Orientation opposite();

    public static Orientation orientation(Position from, Position to) {
        double deltaY;
        double deltaX = Math.abs(from.getX() - to.getX());
        if (deltaX < (deltaY = Math.abs(from.getY() - to.getY()))) {
            return Orientation.verticalOrientation(from, to);
        }
        return Orientation.horizontalOrientation(from, to);
    }

    public static Orientation orientation(Orientation hint, Position from, Position to) {
        if (hint == null) {
            return Orientation.orientation(from, to);
        }
        if (hint instanceof VerticalOrientation) {
            return Orientation.verticalOrientation(from, to);
        }
        if (hint instanceof HorizontalOrientation) {
            return Orientation.horizontalOrientation(from, to);
        }
        throw new IllegalArgumentException("Unexpected hint orientation: " + hint);
    }

    public static Orientation horizontalOrientation(Position from, Position to) {
        return from.getX() < to.getX() ? EAST : WEST;
    }

    public static Orientation verticalOrientation(Position from, Position to) {
        return from.getY() < to.getY() ? SOUTH : NORTH;
    }

    public static abstract class HorizontalOrientation
    extends Orientation {
    }

    public static abstract class VerticalOrientation
    extends Orientation {
    }
}

