/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.documentation.graphic.layout;

import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.Method;
import com.patternity.core.metamodel.OccurrenceTemplate;
import com.patternity.core.metamodel.PatternOccurrence;
import com.patternity.core.metamodel.Relation;
import com.patternity.core.metamodel.Type;
import com.patternity.documentation.graphic.layout.DiagramPrinter;
import com.patternity.graphic.behavioral.Agent;
import com.patternity.graphic.behavioral.Message;
import com.patternity.graphic.behavioral.Note;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.layout.sequence.SequenceLayout;
import com.patternity.util.FileUtils;
import com.patternity.util.TemplatedWriter;
import java.io.File;

public class SequenceDiagramPrinter
extends DiagramPrinter {
    public static void printDiagram(File baseDir, Element[] orderedElements, OccurrenceTemplate shallow, PatternOccurrence deep) {
        Node root = new Node(new Message(null, null));
        for (int i = 0; i < orderedElements.length; ++i) {
            Element rawElement = orderedElements[i];
            SequenceDiagramPrinter.foreachElement(rawElement, shallow, deep, root);
        }
        SequenceLayout layout = new SequenceLayout(16);
        String s = layout.layout(root);
        String patternName = deep.getPattern().getName();
        FileUtils.makeDirs(baseDir);
        TemplatedWriter writer = new TemplatedWriter(new File(baseDir, patternName + "_sequence-diagram.svg"), new File("template.svg"));
        writer.write(s, "viewBox=\"0 0 1000 1000\"");
    }

    private static void foreachElement(Element rawElement, OccurrenceTemplate shallow, PatternOccurrence deep, Node root) {
        Element element = SequenceDiagramPrinter.evaluateDefinition(rawElement, shallow, deep);
        if (element instanceof com.patternity.core.metamodel.Note) {
            com.patternity.core.metamodel.Note note = (com.patternity.core.metamodel.Note)element;
            Node node = new Node(new Note(note.getText()));
            root.add(node);
            return;
        }
        if (element instanceof PatternOccurrence) {
            PatternOccurrence occ = (PatternOccurrence)element;
            if (!(occ.getPattern() instanceof Relation)) {
                return;
            }
            Element source = occ.get("Source");
            Node current = root;
            if (source != null) {
                Node node = new Node(SequenceDiagramPrinter.message(source));
                root.add(node);
                current = node;
            }
            Element target = occ.get("Target");
            for (Element eachTarget : SequenceDiagramPrinter.strip(target)) {
                Node node = new Node(SequenceDiagramPrinter.message(eachTarget));
                current.add(node);
            }
        }
    }

    public static Message message(Element element) {
        if (element instanceof PatternOccurrence) {
            return null;
        }
        if (element instanceof Method) {
            return SequenceDiagramPrinter.message((Method)element);
        }
        if (element instanceof Type) {
            Method method = new Method();
            method.setType((Type)element);
            return SequenceDiagramPrinter.message(method);
        }
        return null;
    }

    public static Message message(Method method) {
        Type type = method.getType();
        return new Message(new Agent(type.getName(), SequenceDiagramPrinter.instanceName(type)), method.isUnknown() ? "..." : method.shortSignature());
    }

    public static String instanceName(Type type) {
        return type == null ? "..." : "";
    }
}

