/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.documentation.graphic.layout;

import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.Note;
import com.patternity.core.metamodel.OccurrenceTemplate;
import com.patternity.core.metamodel.Pattern;
import com.patternity.core.metamodel.PatternOccurrence;
import com.patternity.core.metamodel.Relation;
import com.patternity.core.metamodel.Type;
import com.patternity.documentation.graphic.layout.BinaryRelation;
import com.patternity.documentation.graphic.layout.DiagramPrinter;
import com.patternity.documentation.graphic.layout.Hierarchy;
import com.patternity.graphic.BoundingBox;
import com.patternity.graphic.Position;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.layout.GridLayout;
import com.patternity.graphic.layout.HierarchyLayout;
import com.patternity.graphic.svg.BoxRenderer;
import com.patternity.graphic.svg.BoxStyle;
import com.patternity.graphic.svg.LinkRenderer;
import com.patternity.graphic.svg.LinkStyle;
import com.patternity.util.FileUtils;
import com.patternity.util.TemplatedWriter;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassDiagramPrinter
extends DiagramPrinter {
    private final BoundingBox grid = new BoundingBox(140, 120);
    private final BoundingBox cell = new BoundingBox(100, 80);
    private final GridLayout gridLayout = GridLayout.gridLR(new HierarchyLayout(), this.grid, Position.ZERO);
    private final BoxRenderer renderer = new BoxRenderer(this.gridLayout, this.cell, 16);
    private final LinkRenderer linkRenderer = new LinkRenderer();
    private final Map boxes = new HashMap();
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 0;
    private File baseDir;

    public ClassDiagramPrinter(File baseDir) {
        this.baseDir = baseDir;
        FileUtils.makeDirs(baseDir);
    }

    public void printDiagram(Element[] orderedElements, OccurrenceTemplate shallow, PatternOccurrence deep) {
        String diagram = "class-diagram";
        Hierarchy printTree = new Hierarchy();
        this.processElements(orderedElements, shallow, deep, printTree);
        System.out.println("***");
        System.out.println(printTree.getRootNode());
        System.out.println(printTree.getRelations());
        this.print(printTree);
        String s = this.buffer.toString();
        String patternName = deep.getPattern().getName();
        TemplatedWriter writer = new TemplatedWriter(new File(this.baseDir, patternName + "_" + "class-diagram" + ".svg"), new File("template.svg"));
        writer.write(s, "viewBox=\"0 0 1000 1000\"");
    }

    private void processElements(Element[] orderedElements, OccurrenceTemplate shallow, PatternOccurrence deep, Hierarchy printTree) {
        for (int i = 0; i < orderedElements.length; ++i) {
            Element rawElement = orderedElements[i];
            this.foreachElement(rawElement, shallow, deep, printTree);
        }
    }

    private void foreachElement(Element rawElement, OccurrenceTemplate shallow, PatternOccurrence deep, Hierarchy printTree) {
        Element element = ClassDiagramPrinter.evaluateDefinition(rawElement, shallow, deep);
        this.walk(printTree, element);
    }

    private void addRelation(Hierarchy printTree, Element element) {
        if (!(element instanceof PatternOccurrence)) {
            return;
        }
        PatternOccurrence occ = (PatternOccurrence)element;
        if (!occ.isRelationOccurrence()) {
            return;
        }
        Relation relation = (Relation)occ.getPattern();
        if (relation.getKind().equalsIgnoreCase("DELEGATION")) {
            System.out.println("!!! IGNORED DELEGATION relation");
            return;
        }
        Element source = occ.get("Source");
        if (source == null) {
            return;
        }
        Element target = this.gotoTop(occ.get("Target"));
        System.out.println("adding relation: " + source + " => " + target + " (" + relation.getKind() + ")");
        printTree.add(source, target, relation.getKind());
    }

    private Element gotoTop(Element element) {
        PatternOccurrence occ;
        if (element instanceof PatternOccurrence && (occ = (PatternOccurrence)element).isHierarchyOccurrence()) {
            return occ.get("Top");
        }
        return element;
    }

    private void walk(Hierarchy printTree, Element element) {
        ++this.depth;
        String indent = "";
        for (int i = 0; i < this.depth; ++i) {
            indent = indent + "  ";
        }
        System.out.println(indent + "walk: " + element);
        this.addRelation(printTree, element);
        if (element instanceof PatternOccurrence) {
            PatternOccurrence occ = (PatternOccurrence)element;
            boolean isSet = occ.isSetOccurrence();
            for (Element member : occ.allElements()) {
                this.walk(printTree, member);
                if (!isSet) continue;
                PatternOccurrence missingCollaboration = Relation.COLLABORATION_RELATION.newOccurrence(occ, member);
                this.addRelation(printTree, missingCollaboration);
            }
        }
        --this.depth;
    }

    private void print(Hierarchy hierarchy) {
        this.printHierarchyBoxes(hierarchy);
        this.printLinks(hierarchy.getRelations());
    }

    private void printLinks(Collection links) {
        for (BinaryRelation binaryRelation : links) {
            this.printRelation(binaryRelation);
        }
    }

    protected void printHierarchyBoxes(Hierarchy hierarchy) {
        Iterator iterator = hierarchy.dfsIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.renderBox(node);
        }
        this.buffer.append("\n" + this.renderer.getContent());
    }

    private void printRelation(BinaryRelation relation) {
        Element source = relation.getSource();
        Element target = relation.getTarget();
        if (source == null || target == null) {
            return;
        }
        String kind = relation.getKind();
        this.renderLink(source, target, kind);
    }

    private void renderBox(Node node) {
        BoxStyle boxStyle = this.boxStyleFor(node.getElement());
        if (boxStyle == null) {
            return;
        }
        this.renderer.render(node, this.boxes, boxStyle);
    }

    public void renderLink(Element source, Element target, String kind) {
        LinkStyle linkStyle = this.linkStyleFor(kind);
        if (linkStyle == null) {
            return;
        }
        this.linkRenderer.render(source, target, this.boxes, linkStyle);
        this.buffer.append("\n" + this.renderer.getContent());
    }

    protected BoxStyle boxStyleFor(Object item) {
        if (item instanceof Type) {
            return BoxStyle.TYPE;
        }
        if (item instanceof Note) {
            return BoxStyle.NOTE;
        }
        if (item instanceof PatternOccurrence) {
            PatternOccurrence occurrence = (PatternOccurrence)item;
            Pattern pattern = occurrence.getPattern();
            if (pattern.equals(PatternOccurrence.SET_PATTERN)) {
                return BoxStyle.SET;
            }
            return BoxStyle.PATTERN;
        }
        return null;
    }

    protected LinkStyle linkStyleFor(String kind) {
        if (kind.equals("INHERITANCE")) {
            return LinkStyle.GENERALIZATION;
        }
        if (kind.equals("DELEGATION")) {
            return LinkStyle.DELEGATION;
        }
        if (kind.equals("ALLOCATION")) {
            return LinkStyle.ALLOCATION;
        }
        if (kind.equals("COLLABORATION")) {
            return LinkStyle.COLLABORATION;
        }
        return null;
    }
}

