/*
 * Decompiled with CFR 0.152.
 */
package com.patternity.core.metamodel;

import com.patternity.core.metamodel.Element;
import com.patternity.core.metamodel.Pattern;
import com.patternity.core.metamodel.PatternOccurrence;
import com.patternity.core.metamodel.Role;

public interface Relation
extends Pattern {
    public static final String INHERITANCE = "INHERITANCE";
    public static final String DELEGATION = "DELEGATION";
    public static final String DEPENDENCY = "DEPENDENCY";
    public static final String ALLOCATION = "ALLOCATION";
    public static final String COLLABORATION = "COLLABORATION";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String CONTAINMENT = "CONTAINMENT";
    public static final String GHOST = "GHOST";
    public static final Relation INHERITANCE_RELATION = new RelationPattern("INHERITANCE");
    public static final Relation DELEGATION_RELATION = new RelationPattern("DELEGATION");
    public static final Relation ALLOCATION_RELATION = new RelationPattern("ALLOCATION");
    public static final Relation COLLABORATION_RELATION = new RelationPattern("COLLABORATION");

    public String getKind();

    public PatternOccurrence newOccurrence(Element var1, Element var2);

    public static class RelationPattern
    implements Relation {
        private final String kind;

        public RelationPattern(String kind) {
            this.kind = kind;
        }

        @Override
        public String getKind() {
            return this.kind;
        }

        @Override
        public String getName() {
            return this.kind;
        }

        @Override
        public PatternOccurrence newOccurrence(Element source, Element target) {
            PatternOccurrence occ = new PatternOccurrence(this);
            occ.add(new Role("Source", source));
            occ.add(new Role("Target", target));
            return occ;
        }

        public String toString() {
            return "RelationPattern " + this.getKind();
        }
    }
}

