/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class RestData {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final List<Header> headers = new ArrayList<Header>();
    private String body;
    private String resource;
    private Long transactionId;

    public String getBody() {
        return this.body;
    }

    public RestData setBody(String body) {
        this.body = body;
        return this;
    }

    public String getResource() {
        return this.resource;
    }

    public RestData setResource(String resource) {
        this.resource = resource;
        return this;
    }

    public RestData setTransactionId(Long txId) {
        this.transactionId = txId;
        return this;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<Header> getHeader(String name) {
        ArrayList<Header> headersWithTheSameName = new ArrayList<Header>();
        for (Header h : this.headers) {
            if (!h.getName().equalsIgnoreCase(name)) continue;
            headersWithTheSameName.add(h);
        }
        return headersWithTheSameName;
    }

    public RestData addHeader(String name, String value) {
        this.headers.add(new Header(name, value));
        return this;
    }

    public RestData addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            this.addHeader(e.getKey(), e.getValue());
        }
        return this;
    }

    public RestData addHeaders(List<Header> headers) {
        for (Header e : headers) {
            this.addHeader(e.getName(), e.getValue());
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Header h : this.getHeaders()) {
            builder.append(h).append(LINE_SEPARATOR);
        }
        if (this.body != null) {
            builder.append(LINE_SEPARATOR);
            builder.append(this.getBody());
        } else {
            builder.append("[empty/null body]");
        }
        return builder.toString();
    }

    public static class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            if (name == null || value == null) {
                throw new IllegalArgumentException("Name or Value is null");
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.getName().hashCode() + 37 * this.getValue().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Header)) {
                return false;
            }
            Header h = (Header)o;
            return this.getName().equals(h.getName()) && this.getValue().equals(h.getValue());
        }

        public String toString() {
            return String.format("%s:%s", this.getName(), this.getValue());
        }
    }
}

