/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartrics.rest.client.RestClient;
import smartrics.rest.client.RestData;
import smartrics.rest.client.RestRequest;
import smartrics.rest.client.RestResponse;

public class RestClientImpl
implements RestClient {
    private static Logger LOG = LoggerFactory.getLogger(RestClientImpl.class);
    private final HttpClient client;
    private String baseUrl;

    public RestClientImpl(HttpClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Null HttpClient instance");
        }
        this.client = client;
    }

    @Override
    public void setBaseUrl(String bUrl) {
        this.baseUrl = bUrl;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public RestResponse execute(RestRequest request) {
        return this.execute(this.getBaseUrl(), request);
    }

    @Override
    public RestResponse execute(String hostAddr, RestRequest request) {
        if (request == null || !request.isValid()) {
            throw new IllegalArgumentException("Invalid request " + request);
        }
        if (request.getTransactionId() == null) {
            request.setTransactionId(System.currentTimeMillis());
        }
        LOG.debug("request: {}", (Object)request);
        HttpMethod m = this.createHttpClientMethod(request);
        this.configureHttpMethod(m, hostAddr, request);
        RestResponse resp = new RestResponse();
        resp.setTransactionId(request.getTransactionId());
        resp.setResource(request.getResource());
        try {
            this.client.executeMethod(m);
            for (Header h : m.getResponseHeaders()) {
                resp.addHeader(h.getName(), h.getValue());
            }
            resp.setStatusCode(m.getStatusCode());
            resp.setStatusText(m.getStatusText());
            resp.setBody(m.getResponseBodyAsString());
        }
        catch (HttpException e) {
            String message = "Http call failed for protocol failure";
            throw new IllegalStateException(message, e);
        }
        catch (IOException e) {
            String message = "Http call failed for IO failure";
            throw new IllegalStateException(message, e);
        }
        finally {
            m.releaseConnection();
        }
        LOG.debug("response: {}", (Object)resp);
        return resp;
    }

    protected void configureHttpMethod(HttpMethod m, String hostAddr, final RestRequest request) {
        this.addHeaders(m, request);
        this.setUri(m, hostAddr, request);
        m.setQueryString(request.getQuery());
        if (m instanceof EntityEnclosingMethod) {
            RequestEntity requestEntity = null;
            String fileName = request.getFileName();
            requestEntity = fileName != null ? this.configureFileUpload(fileName) : ((fileName = request.getMultipartFileName()) != null ? this.configureMultipartFileUpload(m, request, requestEntity, fileName) : new RequestEntity(){

                public boolean isRepeatable() {
                    return true;
                }

                public void writeRequest(OutputStream out) throws IOException {
                    PrintWriter printer = new PrintWriter(out);
                    printer.print(request.getBody());
                    printer.flush();
                }

                public long getContentLength() {
                    return request.getBody().getBytes().length;
                }

                public String getContentType() {
                    List<RestData.Header> values = request.getHeader("Content-Type");
                    String v = "text/xml";
                    if (values.size() != 0) {
                        v = values.get(0).getValue();
                    }
                    return v;
                }
            });
            ((EntityEnclosingMethod)m).setRequestEntity(requestEntity);
        }
    }

    private RequestEntity configureMultipartFileUpload(HttpMethod m, RestRequest request, RequestEntity requestEntity, String fileName) {
        File file = new File(fileName);
        try {
            requestEntity = new MultipartRequestEntity(new Part[]{new FilePart(request.getMultipartFileParameterName(), file)}, ((EntityEnclosingMethod)m).getParams());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found: " + fileName, e);
        }
        return requestEntity;
    }

    private RequestEntity configureFileUpload(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + fileName);
        }
        return new FileRequestEntity(file, "application/octet-stream");
    }

    public String getContentType(RestRequest request) {
        List<RestData.Header> values = request.getHeader("Content-Type");
        String v = "text/xml";
        if (values.size() != 0) {
            v = values.get(0).getValue();
        }
        return v;
    }

    private void setUri(HttpMethod m, String hostAddr, RestRequest request) {
        String host;
        String string = host = hostAddr == null ? this.client.getHostConfiguration().getHost() : hostAddr;
        if (host == null) {
            throw new IllegalStateException("hostAddress is null: please config httpClient host configuration or pass a valid host address or config a baseUrl on this client");
        }
        String uriString = host + request.getResource();
        try {
            m.setURI(this.createUri(uriString, false));
        }
        catch (URIException e) {
            throw new IllegalStateException("Problem when building URI: " + uriString, e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Building URI with null string", e);
        }
    }

    protected URI createUri(String uriString, boolean escaped) throws URIException {
        return new URI(uriString, escaped);
    }

    protected String getMethodClassnameFromMethodName(String mName) {
        return String.format("org.apache.commons.httpclient.methods.%sMethod", mName);
    }

    protected HttpMethod createHttpClientMethod(RestRequest request) {
        String mName = request.getMethod().toString();
        String className = this.getMethodClassnameFromMethodName(mName);
        try {
            Class<?> clazz = Class.forName(className);
            HttpMethod m = (HttpMethod)clazz.newInstance();
            return m;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(className + " not found: you may be using a too old or " + "too new version of HttpClient", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("An object of type " + className + " cannot be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The default ctor for type " + className + " cannot be invoked", e);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception when instantiating: " + className, e);
        }
    }

    private void addHeaders(HttpMethod m, RestRequest request) {
        for (RestData.Header h : request.getHeaders()) {
            m.addRequestHeader(h.getName(), h.getValue());
        }
    }
}

