/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.identity.experimental;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;

public class JWT {
    private final String header;
    private final String signature;
    private final String payload;
    private final String token;

    public JWT(String token) {
        this.token = token;
        String[] chunks = token.split("\\.");
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            this.header = new String(decoder.decode(chunks[0]));
            this.payload = new String(decoder.decode(chunks[1]));
            this.signature = chunks[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid JWT token");
        }
    }

    public String toNiceString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject h = (JsonObject)gson.fromJson(this.header, JsonObject.class);
        try {
            JsonObject p = (JsonObject)gson.fromJson(this.payload, JsonObject.class);
            long exp = p.get("exp").getAsLong();
            long iat = p.get("iat").getAsLong();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String sExp = simpleDateFormat.format(new Date(exp * 1000L));
            String sIat = simpleDateFormat.format(new Date(iat * 1000L));
            p.remove("exp");
            p.remove("iat");
            p.addProperty("exp", sExp);
            p.addProperty("iat", sIat);
            JsonObject obj = (JsonObject)gson.fromJson("{}", JsonObject.class);
            obj.add("header", (JsonElement)h);
            obj.add("payload", (JsonElement)p);
            obj.addProperty("signature", this.signature);
            return obj.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid token", e);
        }
    }

    public String toString() {
        return "JWT{header='" + this.header + "', payload='" + this.payload + "', signature='" + this.signature + "'}";
    }
}

