/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.identity;

import java.time.Duration;
import smartrics.iotics.identity.Identity;
import smartrics.iotics.identity.IdentityManager;
import smartrics.iotics.identity.SimpleIdentity;
import smartrics.iotics.identity.jna.JnaSdkApiInitialiser;
import smartrics.iotics.identity.jna.SdkApi;

public class SimpleIdentityManager
implements IdentityManager {
    private final Identity agentIdentity;
    private final Identity userIdentity;
    private final SimpleIdentity idSdk;

    private SimpleIdentityManager(String resolverAddress, String userSeed, String agentSeed, String userKeyName, String userKeyID, String agentKeyName, String agentKeyID, String authDelegationID) {
        SdkApi api = new JnaSdkApiInitialiser().get();
        this.idSdk = new SimpleIdentity(api, resolverAddress, userSeed, agentSeed);
        this.userIdentity = this.idSdk.CreateUserIdentity(userKeyName, userKeyID);
        this.agentIdentity = this.idSdk.CreateAgentIdentity(agentKeyName, agentKeyID);
        this.idSdk.UserDelegatesAuthenticationToAgent(this.agentIdentity, this.userIdentity, authDelegationID);
    }

    @Override
    public String newAuthenticationToken(Duration expiry) {
        return this.newAuthenticationToken(expiry, "undefined");
    }

    @Override
    public String newAuthenticationToken(Duration expiry, String audience) {
        return this.idSdk.CreateAgentAuthToken(this.agentIdentity, this.userIdentity.did(), audience, expiry);
    }

    @Override
    public Identity newTwinIdentity(String twinKeyName, String controlDelegationID) {
        return this.idSdk.CreateTwinIdentityWithControlDelegation(this.agentIdentity, twinKeyName, controlDelegationID);
    }

    @Override
    public Identity agentIdentity() {
        return this.agentIdentity;
    }

    @Override
    public Identity userIdentity() {
        return this.userIdentity;
    }

    public static final class Builder {
        private String userSeed;
        private String agentSeed;
        private String userKeyName;
        private String agentKeyName;
        private String userKeyID = "#user-0";
        private String agentKeyID = "agent-0";
        private String authDelegationID = "#deleg-0";
        private String resolverAddress;

        private Builder() {
        }

        public static Builder anIdentityManager() {
            return new Builder();
        }

        public Builder withUserSeed(String userSeed) {
            this.userSeed = userSeed;
            return this;
        }

        public Builder withAgentSeed(String agentSeed) {
            this.agentSeed = agentSeed;
            return this;
        }

        public Builder withUserKeyName(String userKeyName) {
            this.userKeyName = userKeyName;
            return this;
        }

        public Builder withUserKeyID(String userKeyID) {
            this.userKeyID = userKeyID;
            return this;
        }

        public Builder withAgentKeyName(String agentKeyName) {
            this.agentKeyName = agentKeyName;
            return this;
        }

        public Builder withAgentKeyID(String agentKeyID) {
            this.agentKeyID = agentKeyID;
            return this;
        }

        public Builder withResolverAddress(String resolverAddress) {
            this.resolverAddress = resolverAddress;
            return this;
        }

        public Builder withAuthDelegationID(String authDelegationID) {
            this.authDelegationID = authDelegationID;
            return this;
        }

        public SimpleIdentityManager build() {
            return new SimpleIdentityManager(this.resolverAddress, this.userSeed, this.agentSeed, this.userKeyName, this.userKeyID, this.agentKeyName, this.agentKeyID, this.authDelegationID);
        }
    }
}

