/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.identity;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import smartrics.iotics.identity.Identity;
import smartrics.iotics.identity.Validator;
import smartrics.iotics.identity.jna.SdkApi;
import smartrics.iotics.identity.resolver.HttpResolverClient;

public class SimpleIdentity {
    private final SdkApi api;
    private final String userSeed;
    private final String agentSeed;
    private final URL resolverAddress;
    private final HttpResolverClient resolverClient;

    public SimpleIdentity(SdkApi api, String resolverAddress) {
        this(api, resolverAddress, Validator.getValueOrThrow(api.CreateDefaultSeed()));
    }

    public SimpleIdentity(SdkApi api, String resolverAddress, String seed) {
        this(api, resolverAddress, seed, seed);
    }

    public SimpleIdentity(SdkApi api, String resolverAddress, String userSeed, String agentSeed) {
        this.api = Objects.requireNonNull(api);
        this.userSeed = Objects.requireNonNull(userSeed);
        this.agentSeed = Objects.requireNonNull(agentSeed);
        try {
            this.resolverAddress = URI.create(resolverAddress).toURL();
            this.resolverClient = new HttpResolverClient(this.resolverAddress);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("resolver address not a valid URL: " + resolverAddress);
        }
    }

    public Identity CreateAgentIdentity(String keyName, String name) {
        String did = Validator.getValueOrThrow(this.api.CreateAgentIdentity(this.resolverAddress.toString(), keyName, name, this.agentSeed));
        return new Identity(keyName, name, did);
    }

    public Identity RecreateAgentIdentity(String keyName, String name) {
        String did = Validator.getValueOrThrow(this.api.RecreateAgentIdentity(this.resolverAddress.toString(), keyName, name, this.agentSeed));
        return new Identity(keyName, name, did);
    }

    public Identity CreateUserIdentity(String keyName, String name) {
        String did = Validator.getValueOrThrow(this.api.CreateUserIdentity(this.resolverAddress.toString(), keyName, name, this.userSeed));
        return new Identity(keyName, name, did);
    }

    public Identity RecreateUserIdentity(String keyName, String name) {
        String did = Validator.getValueOrThrow(this.api.RecreateUserIdentity(this.resolverAddress.toString(), keyName, name, this.userSeed));
        return new Identity(keyName, name, did);
    }

    public Identity CreateTwinIdentityWithControlDelegation(Identity agentIdentity, String twinKeyName, String twinName) {
        String did = Validator.getValueOrThrow(this.api.CreateTwinDidWithControlDelegation(this.resolverAddress.toString(), agentIdentity.did(), agentIdentity.keyName(), agentIdentity.name(), this.agentSeed, twinKeyName, twinName));
        return new Identity(twinKeyName, twinName, did);
    }

    public String CreateAgentAuthToken(Identity agentIdentity, String userDid, String audience, Duration duration) {
        return Validator.getValueOrThrow(this.api.CreateAgentAuthToken(agentIdentity.did(), agentIdentity.keyName(), agentIdentity.name(), this.agentSeed, userDid, audience, duration.toSeconds()));
    }

    public String CreateAgentAuthToken(Identity agentIdentity, String userDid, Duration duration) {
        return this.CreateAgentAuthToken(agentIdentity, userDid, this.resolverAddress.toString(), duration);
    }

    public String RecreateAgentAuthToken(Identity agentIdentity, String userDid, String audience, Duration duration) {
        return Validator.getValueOrThrow(this.api.CreateAgentAuthToken(agentIdentity.did(), agentIdentity.keyName(), agentIdentity.name(), this.agentSeed, userDid, audience, duration.toSeconds()));
    }

    public String RecreateAgentAuthToken(Identity agentIdentity, String userDid, Duration duration) {
        return this.CreateAgentAuthToken(agentIdentity, userDid, this.resolverAddress.toString(), duration);
    }

    public String IsAllowedFor(String resolverAddress, String token) {
        return Validator.getValueOrThrow(this.api.IsAllowedFor(resolverAddress, token));
    }

    public void UserDelegatesAuthenticationToAgent(Identity agentId, Identity userId, String delegationName) {
        Validator.throwIfNotNull(this.api.UserDelegatesAuthenticationToAgent(this.resolverAddress.toString(), agentId.did(), agentId.keyName(), agentId.name(), this.agentSeed, userId.did(), userId.keyName(), userId.name(), this.userSeed, delegationName));
    }

    public void TwinDelegatesControlToAgent(Identity agentId, Identity twinId, String delegationName) {
        Validator.throwIfNotNull(this.api.TwinDelegatesControlToAgent(this.resolverAddress.toString(), agentId.did(), agentId.keyName(), agentId.name(), this.agentSeed, twinId.did(), twinId.keyName(), twinId.name(), this.agentSeed, delegationName));
    }

    String getAgentSeed() {
        return this.agentSeed;
    }

    String getUserSeed() {
        return this.userSeed;
    }

    public URL getResolverAddress() {
        return this.resolverAddress;
    }
}

