/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.identity.experimental;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Base64;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

public final class ResolverClient {
    private final URL base;
    private final OkHttpClient client;

    public ResolverClient(URL base) {
        this.base = base;
        this.client = new OkHttpClient();
    }

    public Result discover(String did) throws IOException {
        URL url = null;
        try {
            url = new URL(this.base, "/1.0/discover/" + did);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid did");
        }
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody body = response.body();
            if (response.code() > 299) {
                if (response.code() == 404) {
                    Result result = new Result("DID not found", "application/text", true);
                    return result;
                }
                if (body != null) {
                    Result result = new Result(body.string(), "application/xml", true);
                    return result;
                }
                Result result = new Result("No result found", "application/text", true);
                return result;
            }
            if (body == null) {
                Result result = new Result("invalid response", "application/text", true);
                return result;
            }
            JSONObject obj = new JSONObject(body.string());
            String token = obj.getString("token");
            Base64.Decoder decoder = Base64.getDecoder();
            String payload = new String(decoder.decode(token.split("\\.")[1]));
            obj = new JSONObject(payload);
            Result result = new Result(obj.toString(3), "application/json", false);
            return result;
        }
    }

    public static void main(String[] args) throws Exception {
        ResolverClient c = new ResolverClient(URI.create("https://did.stg.iotics.com").toURL());
        Result agent = c.discover("did:iotics:iotJxn2AHBkaFXKkBymbFYcVokGhLShLtUf1");
        Result user = c.discover("did:iotics:iotLUmwHDFtpfLEWTeGAQwyp4Y5FoSTt4jbg");
        System.out.println("AGENT ------");
        System.out.println(agent);
        System.out.println("USER ------");
        System.out.println(user);
    }

    public static final class Result {
        private final String content;
        private final String contentType;
        private final boolean isErr;

        public Result(String content, String contentType, boolean isErr) {
            this.content = content;
            this.contentType = contentType;
            this.isErr = isErr;
        }

        public String toString() {
            return "Result{content='" + this.content + "', contentType='" + this.contentType + "', isErr=" + this.isErr + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.isErr == result.isErr && Objects.equals(this.content, result.content) && Objects.equals(this.contentType, result.contentType);
        }

        public int hashCode() {
            return Objects.hash(this.content, this.contentType, this.isErr);
        }

        public String content() {
            return this.content;
        }

        public String contentType() {
            return this.contentType;
        }

        public boolean isErr() {
            return this.isErr;
        }
    }
}

