/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.protobuf.Timestamp;
import com.iotics.api.SearchRequest;
import com.iotics.api.SearchResponse;
import com.iotics.api.SparqlQueryRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.time.Instant;
import smartrics.iotics.connectors.twins.ApiUser;
import smartrics.iotics.connectors.twins.Identifiable;
import smartrics.iotics.connectors.twins.SearchException;
import smartrics.iotics.connectors.twins.SparqlQueryResponseStreamObserver;
import smartrics.iotics.host.Builders;
import smartrics.iotics.identity.Identity;

public interface Searcher
extends Identifiable,
ApiUser {
    default public void query(SparqlQueryRequest.Payload payload, StreamObserver<String> delegate) {
        SparqlQueryRequest request = SparqlQueryRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity()).build()).setPayload(payload).build();
        this.ioticsApi().metaAPI().sparqlQuery(request, (StreamObserver)new SparqlQueryResponseStreamObserver(delegate));
    }

    default public void search(SearchRequest.Payload searchRequestPayload, Duration searchTimeout, final StreamObserver<SearchResponse.TwinDetails> twinDetailsStreamObserver) {
        StreamObserver<SearchResponse> obs = new StreamObserver<SearchResponse>(this){

            public void onNext(SearchResponse searchResponse) {
                if (searchResponse.getPayload().hasStatus()) {
                    twinDetailsStreamObserver.onError((Throwable)new SearchException("Search operation failure", searchResponse.getPayload().getStatus()));
                    return;
                }
                for (SearchResponse.TwinDetails d : searchResponse.getPayload().getTwinsList()) {
                    twinDetailsStreamObserver.onNext((Object)d);
                }
            }

            public void onError(Throwable throwable) {
                StatusRuntimeException e;
                if (throwable instanceof StatusRuntimeException && Status.Code.DEADLINE_EXCEEDED.equals((Object)(e = (StatusRuntimeException)throwable).getStatus().getCode())) {
                    twinDetailsStreamObserver.onCompleted();
                    return;
                }
                twinDetailsStreamObserver.onError(throwable);
            }

            public void onCompleted() {
                twinDetailsStreamObserver.onCompleted();
            }
        };
        SearchRequest request = SearchRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity()).setRequestTimeout(Timestamp.newBuilder().setSeconds(Instant.now().getEpochSecond() + searchTimeout.getSeconds()).build()).build()).setPayload(searchRequestPayload).build();
        this.ioticsApi().searchAPI().synchronousSearch(request, (StreamObserver)obs);
    }
}

