/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.iotics.api.DeleteTwinRequest;
import com.iotics.api.DeleteTwinResponse;
import com.iotics.api.DescribeTwinResponse;
import com.iotics.api.TwinID;
import com.iotics.api.UpsertTwinResponse;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.Executor;
import smartrics.iotics.connectors.twins.Describer;
import smartrics.iotics.connectors.twins.Identifiable;
import smartrics.iotics.host.Builders;
import smartrics.iotics.identity.Identity;

public interface Maker
extends Identifiable,
Describer {
    private static FutureCallback<DescribeTwinResponse> describeCallback(final Maker maker, final SettableFuture<TwinID> future, final Executor executor) {
        return new FutureCallback<DescribeTwinResponse>(){

            public void onSuccess(DescribeTwinResponse describeTwinResponse) {
                future.set((Object)describeTwinResponse.getPayload().getTwinId());
            }

            public void onFailure(Throwable thrown) {
                StatusRuntimeException sre;
                if (thrown instanceof StatusRuntimeException && (sre = (StatusRuntimeException)thrown).getStatus().getCode() == Status.Code.NOT_FOUND) {
                    Futures.addCallback(maker.upsert(), Maker.makeCallback((SettableFuture<TwinID>)future), (Executor)executor);
                } else {
                    future.setException(thrown);
                }
            }
        };
    }

    private static FutureCallback<UpsertTwinResponse> makeCallback(final SettableFuture<TwinID> future) {
        return new FutureCallback<UpsertTwinResponse>(){

            public void onSuccess(UpsertTwinResponse upsertTwinResponse) {
                future.set((Object)upsertTwinResponse.getPayload().getTwinId());
            }

            public void onFailure(Throwable throwable) {
                future.setException(throwable);
            }
        };
    }

    public ListenableFuture<UpsertTwinResponse> upsert();

    default public Executor getExecutor() {
        return MoreExecutors.directExecutor();
    }

    default public ListenableFuture<DeleteTwinResponse> delete() {
        return this.ioticsApi().twinAPIFuture().deleteTwin(DeleteTwinRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity()).build()).setArgs(DeleteTwinRequest.Arguments.newBuilder().setTwinId(TwinID.newBuilder().setId(this.getMyIdentity().did()).build()).build()).build());
    }

    default public ListenableFuture<TwinID> makeIfAbsent() {
        SettableFuture future = SettableFuture.create();
        Futures.addCallback(this.describe(), Maker.describeCallback(this, (SettableFuture<TwinID>)future, this.getExecutor()), (Executor)this.getExecutor());
        return future;
    }
}

