/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.protobuf.BoolValue;
import com.iotics.api.FeedID;
import com.iotics.api.FetchInterestRequest;
import com.iotics.api.FetchInterestResponse;
import com.iotics.api.Interest;
import com.iotics.api.TwinID;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import smartrics.iotics.connectors.twins.ApiUser;
import smartrics.iotics.connectors.twins.Identifiable;
import smartrics.iotics.host.Builders;
import smartrics.iotics.host.wrappers.InterestAPI;
import smartrics.iotics.identity.Identity;

public interface Follower
extends Identifiable,
ApiUser {
    public static final RetryPolicyBuilder<Object> DEF_RETRY_POLICY_FOLLOW_BUILDER = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(StatusRuntimeException.class)).handleIf(e -> {
        StatusRuntimeException sre = (StatusRuntimeException)e;
        return sre.getStatus() == Status.DEADLINE_EXCEEDED || sre.getStatus() == Status.UNAUTHENTICATED || sre.getStatus() == Status.UNAVAILABLE;
    })).withDelay(Duration.ofSeconds(10L)).withMaxRetries(-1).withJitter(Duration.ofMillis(3000L));

    default public Iterator<FetchInterestResponse> follow(FeedID feedId) {
        FetchInterestRequest request = this.newRequest(feedId);
        return this.ioticsApi().interestAPIBlocking().fetchInterests(request);
    }

    default public void followNoRetry(FeedID feedId, StreamObserver<FetchInterestResponse> observer) {
        FetchInterestRequest request = this.newRequest(feedId);
        InterestAPI interestAPI = this.ioticsApi().interestAPI();
        interestAPI.fetchInterests(request, observer);
    }

    default public void follow(FeedID feedID, RetryConf retryConf, final StreamObserver<FetchInterestResponse> observer) {
        Failsafe.with((Policy)DEF_RETRY_POLICY_FOLLOW_BUILDER.withJitter(retryConf.jitter).withDelay(retryConf.delay).build(), (Policy[])new RetryPolicy[0]).runAsync(() -> {
            final CompletableFuture result = new CompletableFuture();
            this.followNoRetry(feedID, new StreamObserver<FetchInterestResponse>(this){

                public void onNext(FetchInterestResponse value) {
                    observer.onNext((Object)value);
                }

                public void onError(Throwable t) {
                    observer.onError(t);
                    result.completeExceptionally(t);
                }

                public void onCompleted() {
                    observer.onCompleted();
                    result.complete(null);
                }
            });
            try {
                result.get();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw e.getCause();
            }
        });
    }

    default public Context.CancellableContext getCancellableContext() {
        return Context.current().withCancellation();
    }

    private FetchInterestRequest newRequest(FeedID feedId) {
        try {
            Identity agentIdentity = this.getAgentIdentity();
            return FetchInterestRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)agentIdentity).build()).setFetchLastStored(BoolValue.newBuilder().setValue(true).build()).setArgs(FetchInterestRequest.Arguments.newBuilder().setInterest(Interest.newBuilder().setFollowerTwinId(TwinID.newBuilder().setId(this.getMyIdentity().did())).setFollowedFeedId(feedId).build()).build()).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public record RetryConf(Duration delay, Duration jitter, Duration backoffDelay, Duration backoffMaxDelay) {
    }
}

