/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.iotics.api.SparqlQueryResponse;
import io.grpc.stub.StreamObserver;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import smartrics.iotics.connectors.twins.SearchException;

class SparqlQueryResponseStreamObserver
implements StreamObserver<SparqlQueryResponse> {
    private final StreamObserver<String> delegate;
    private final List<SparqlQueryResponse.Payload> queue = new CopyOnWriteArrayList<SparqlQueryResponse.Payload>();
    private final AtomicLong expectedTotalPackets = new AtomicLong(-1L);

    SparqlQueryResponseStreamObserver(StreamObserver<String> delegate) {
        this.delegate = delegate;
    }

    public void onNext(SparqlQueryResponse response) {
        SparqlQueryResponse.Payload payload = response.getPayload();
        if (payload.hasStatus()) {
            this.delegate.onError((Throwable)new SearchException("Query operation failure", payload.getStatus()));
            return;
        }
        this.queue.add(payload);
        if (payload.getLast()) {
            this.expectedTotalPackets.set(payload.getSeqNum());
        }
        if (!this.queue.isEmpty() && (long)this.queue.size() == this.expectedTotalPackets.get()) {
            this.queue.sort(Comparator.comparingLong(SparqlQueryResponse.Payload::getSeqNum));
            String fullString = this.queue.stream().map(p -> p.getResultChunk().toStringUtf8()).collect(Collectors.joining());
            this.delegate.onNext((Object)fullString);
            this.delegate.onCompleted();
        }
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }
}

