/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.iotics.api.FeedData;
import com.iotics.api.FeedID;
import com.iotics.api.ShareFeedDataRequest;
import com.iotics.api.ShareFeedDataResponse;
import io.grpc.stub.StreamObserver;
import java.nio.charset.StandardCharsets;
import smartrics.iotics.connectors.twins.ApiUser;
import smartrics.iotics.connectors.twins.Identifiable;
import smartrics.iotics.host.Builders;
import smartrics.iotics.identity.Identity;

public interface Publisher
extends Identifiable,
ApiUser {
    default public ListenableFuture<ShareFeedDataResponse> share(ShareFeedDataRequest request) {
        return this.ioticsApi().feedAPIFuture().shareFeedData(request);
    }

    default public StreamObserver<ShareFeedDataRequest> stream(StreamObserver<ShareFeedDataResponse> response) {
        return this.ioticsApi().feedAPI().streamFeedData(response);
    }

    default public ListenableFuture<ShareFeedDataResponse> share(FeedID feedID, String payload) {
        ShareFeedDataRequest request = this.newRequest(feedID, payload);
        return this.share(request);
    }

    default public ShareFeedDataRequest newRequest(FeedID feedID, String payload) {
        return ShareFeedDataRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity()).build()).setPayload(ShareFeedDataRequest.Payload.newBuilder().setSample(FeedData.newBuilder().setData(ByteString.copyFrom((byte[])payload.getBytes(StandardCharsets.UTF_8))).build()).build()).setArgs(ShareFeedDataRequest.Arguments.newBuilder().setFeedId(feedID).build()).build();
    }
}

