/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.iotics.api.DescribeTwinRequest;
import com.iotics.api.DescribeTwinResponse;
import com.iotics.api.TwinID;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import smartrics.iotics.connectors.twins.ApiUser;
import smartrics.iotics.connectors.twins.Identifiable;
import smartrics.iotics.host.Builders;
import smartrics.iotics.identity.Identity;

public interface Describer
extends Identifiable,
ApiUser {
    default public void describe(TwinID twinID, ScheduledExecutorService scheduler, Duration initialDelay, Duration pollingFrequency, final StreamObserver<DescribeTwinResponse> result) {
        scheduler.scheduleAtFixedRate(() -> {
            ListenableFuture<DescribeTwinResponse> f = this.describe(twinID);
            Futures.addCallback(f, (FutureCallback)new FutureCallback<DescribeTwinResponse>(this){

                public void onSuccess(DescribeTwinResponse describeTwinResponse) {
                    result.onNext((Object)describeTwinResponse);
                }

                public void onFailure(Throwable throwable) {
                    result.onError(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }, initialDelay.toMillis(), pollingFrequency.toMillis(), TimeUnit.MILLISECONDS);
    }

    default public ListenableFuture<DescribeTwinResponse> describe() {
        return this.describe(TwinID.newBuilder().setId(this.getMyIdentity().did()).build());
    }

    default public ListenableFuture<DescribeTwinResponse> describe(TwinID twinID) {
        return this.ioticsApi().twinAPIFuture().describeTwin(DescribeTwinRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity()).build()).setArgs(DescribeTwinRequest.Arguments.newBuilder().setTwinId(TwinID.newBuilder().setId(twinID.getId()).setHostId(twinID.getHostId()).build()).build()).build());
    }
}

