/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import com.iotics.api.FeedData;
import com.iotics.api.GeoLocation;
import com.iotics.api.LangLiteral;
import com.iotics.api.Literal;
import com.iotics.api.Property;
import com.iotics.api.ShareFeedDataRequest;
import com.iotics.api.StringLiteral;
import com.iotics.api.TwinID;
import com.iotics.api.UpsertFeedWithMeta;
import com.iotics.api.UpsertInputWithMeta;
import com.iotics.api.UpsertTwinRequest;
import com.iotics.api.Uri;
import com.iotics.api.Value;
import java.lang.annotation.Annotation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import smartrics.iotics.connectors.twins.annotations.AnnotationData;
import smartrics.iotics.connectors.twins.annotations.Feed;
import smartrics.iotics.connectors.twins.annotations.GenericInvoker;
import smartrics.iotics.connectors.twins.annotations.HostIdentifier;
import smartrics.iotics.connectors.twins.annotations.Identifier;
import smartrics.iotics.connectors.twins.annotations.Input;
import smartrics.iotics.connectors.twins.annotations.LangLiteralProperty;
import smartrics.iotics.connectors.twins.annotations.LiteralProperty;
import smartrics.iotics.connectors.twins.annotations.Location;
import smartrics.iotics.connectors.twins.annotations.PayloadValue;
import smartrics.iotics.connectors.twins.annotations.StringLiteralProperty;
import smartrics.iotics.connectors.twins.annotations.UriProperty;

class AnnotationToApiBuilder {
    AnnotationToApiBuilder() {
    }

    private static <A extends Annotation> Optional<String> getValidIdentifierValue(Object instance, Class<A> annotationClass) {
        List<String> v = GenericInvoker.collectAnnotatedMemberValues(instance, annotationClass).stream().map(annotationData -> annotationData.annotatedElementValue().toString()).toList();
        if (v.size() > 1) {
            throw new IllegalArgumentException("multiple " + annotationClass.getSimpleName() + " annotations");
        }
        if (v.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(v.getFirst());
    }

    List<FeedValue> buildShareFeedDataRequestJSONPayload(Object instance) {
        List<AnnotationData> feeds = GenericInvoker.collectAnnotatedMemberValues(instance, Feed.class);
        ArrayList results = Lists.newArrayListWithCapacity((int)feeds.size());
        feeds.forEach(feedAnnotationData -> {
            String feedId = feedAnnotationData.annotationKvp().get("id").toString();
            List<ValueObject> feedValues = this.buildValues(feedAnnotationData.annotatedElementValue());
            ShareFeedDataRequest.Payload.Builder payloadBuilder = ShareFeedDataRequest.Payload.newBuilder();
            HashMap samples = new HashMap();
            Gson gson = new Gson();
            feedValues.forEach(ve -> {
                String v = null;
                if (ve.valueObject != null) {
                    v = ve.valueObject.toString();
                }
                samples.put(ve.value.getLabel(), v);
            });
            payloadBuilder.setSample(FeedData.newBuilder().setData(ByteString.copyFromUtf8((String)gson.toJson(samples))));
            results.add(new FeedValue(feedId, payloadBuilder.build()));
        });
        return results;
    }

    UpsertTwinRequest.Payload buildUpsertTwinRequestPayload(TwinID twinID, Object instance) {
        UpsertTwinRequest.Payload.Builder builder = UpsertTwinRequest.Payload.newBuilder();
        builder.setTwinId(Optional.ofNullable(twinID).orElseGet(() -> this.buildId(instance)));
        GeoLocation l = this.buildLocation(instance);
        if (l != null) {
            builder.setLocation(l);
        }
        builder.addAllProperties(this.buildProperties(instance));
        builder.addAllFeeds(this.buildFeeds(instance));
        builder.addAllInputs(this.buildInputs(instance));
        return builder.build();
    }

    List<Property> buildProperties(Object instance) {
        return Stream.of(StringLiteralProperty.class, LiteralProperty.class, UriProperty.class, LangLiteralProperty.class).flatMap(aClass -> GenericInvoker.collectAnnotatedMemberValues(instance, aClass).stream()).map(this::buildProperty).toList();
    }

    List<Value> buildValuesMeta(Object instance) {
        return GenericInvoker.collectAnnotatedMemberValues(instance, PayloadValue.class).stream().map(annotationData -> {
            String label;
            String unit;
            String comment;
            Value.Builder vb = Value.newBuilder();
            String dataType = annotationData.annotationKvp().get("dataType").toString();
            if (!dataType.isEmpty()) {
                vb.setDataType(dataType);
            }
            if (!(comment = annotationData.annotationKvp().get("comment").toString()).isEmpty()) {
                vb.setComment(comment);
            }
            if (!(unit = annotationData.annotationKvp().get("unit").toString()).isEmpty()) {
                vb.setUnit(unit);
            }
            if (!(label = annotationData.annotationKvp().get("label").toString()).isEmpty()) {
                vb.setLabel(label);
            } else {
                vb.setLabel(annotationData.methodOrFieldName());
            }
            return vb.build();
        }).toList();
    }

    List<ValueObject> buildValues(Object instance) {
        ArrayList<ValueObject> result = new ArrayList<ValueObject>();
        List<AnnotationData> ad = GenericInvoker.collectAnnotatedMemberValues(instance, PayloadValue.class);
        ad.forEach(annotationData -> {
            Value.Builder vb = Value.newBuilder();
            String label = annotationData.annotationKvp().get("label").toString();
            if (!label.isEmpty()) {
                vb.setLabel(label);
            } else {
                vb.setLabel(annotationData.methodOrFieldName());
            }
            result.add(new ValueObject(vb.build(), annotationData.annotatedElementValue()));
        });
        return result;
    }

    GeoLocation buildLocation(Object instance) {
        List<GeoLocation> v = GenericInvoker.collectAnnotatedMemberValues(instance, Location.class).stream().map(annotationData -> {
            Object o = annotationData.annotatedElementValue();
            if (o instanceof GeoLocation) {
                return (GeoLocation)o;
            }
            throw new IllegalArgumentException("invalid GeoLocation for this annotation: " + String.valueOf(annotationData));
        }).toList();
        if (v.isEmpty()) {
            return null;
        }
        if (v.size() > 1) {
            throw new IllegalArgumentException("multiple GeoLocation attributes for this object");
        }
        return v.getFirst();
    }

    TwinID buildId(Object instance) {
        Optional<String> twinId = AnnotationToApiBuilder.getValidIdentifierValue(instance, Identifier.class);
        TwinID.Builder builder = TwinID.newBuilder();
        builder.setId(twinId.orElseThrow(() -> new IllegalArgumentException("missing Identifier annotation")));
        Optional<String> hostId = AnnotationToApiBuilder.getValidIdentifierValue(instance, HostIdentifier.class);
        hostId.ifPresent(arg_0 -> ((TwinID.Builder)builder).setHostId(arg_0));
        return builder.build();
    }

    List<UpsertFeedWithMeta> buildFeeds(Object instance) {
        return GenericInvoker.collectAnnotatedMemberValues(instance, Feed.class).stream().map(this::buildFeed).toList();
    }

    List<UpsertInputWithMeta> buildInputs(Object instance) {
        return GenericInvoker.collectAnnotatedMemberValues(instance, Input.class).stream().map(this::buildInput).toList();
    }

    Property buildProperty(AnnotationData data) {
        Object annotation = data.annotation();
        String iri = (String)data.annotationKvp().get("iri");
        if (iri == null) {
            throw new IllegalArgumentException("null iri for this annotation: " + String.valueOf(data));
        }
        Property.Builder builder = Property.newBuilder().setKey(iri);
        String annotatedElementValue = data.annotatedElementValue().toString();
        Object object = annotation;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringLiteralProperty.class, LiteralProperty.class, UriProperty.class, LangLiteralProperty.class}, (Object)object2, n)) {
            case 0: {
                StringLiteralProperty slp = (StringLiteralProperty)object2;
                StringLiteral slValue = StringLiteral.newBuilder().setValue(annotatedElementValue).build();
                builder.setStringLiteralValue(slValue);
                break;
            }
            case 1: {
                LiteralProperty literalProperty = (LiteralProperty)object2;
                Literal lValue = Literal.newBuilder().setDataType(literalProperty.dataType().toString()).setValue(annotatedElementValue).build();
                builder.setLiteralValue(lValue);
                break;
            }
            case 2: {
                UriProperty up = (UriProperty)object2;
                builder.setUriValue(Uri.newBuilder().setValue(annotatedElementValue).build());
                break;
            }
            case 3: {
                LangLiteralProperty llp = (LangLiteralProperty)object2;
                LangLiteral llValue = LangLiteral.newBuilder().setLang(llp.lang()).setValue(annotatedElementValue).build();
                builder.setLangLiteralValue(llValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid annotation data: " + String.valueOf(data));
            }
        }
        return builder.build();
    }

    UpsertFeedWithMeta buildFeed(AnnotationData data) {
        UpsertFeedWithMeta.Builder builder = UpsertFeedWithMeta.newBuilder();
        builder.setId(data.annotationKvp().get("id").toString());
        boolean storeLast = Boolean.parseBoolean(data.annotationKvp().get("storeLast").toString());
        builder.setStoreLast(storeLast);
        List<Property> allProps = this.buildProperties(data.annotatedElementValue());
        builder.addAllProperties(allProps);
        List<Value> allValues = this.buildValuesMeta(data.annotatedElementValue());
        builder.addAllValues(allValues);
        return builder.build();
    }

    UpsertInputWithMeta buildInput(AnnotationData data) {
        UpsertInputWithMeta.Builder builder = UpsertInputWithMeta.newBuilder();
        builder.setId(data.annotationKvp().get("id").toString());
        List<Property> allProps = this.buildProperties(data.annotatedElementValue());
        builder.addAllProperties(allProps);
        List<Value> allValues = this.buildValuesMeta(data.annotatedElementValue());
        builder.addAllValues(allValues);
        return builder.build();
    }

    record ValueObject(Value value, Object valueObject) {
    }

    record FeedValue(String feedId, ShareFeedDataRequest.Payload payload) {
    }
}

