/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins.annotations;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import smartrics.iotics.connectors.twins.annotations.AnnotationData;

public class GenericInvoker {
    public static <A extends Annotation> List<AnnotationData> collectAnnotatedMemberValues(Object instance, Class<A> annotationClass) {
        Map<String, Object> keys;
        Object value;
        A annotation;
        ArrayList<AnnotationData> collectedValues = new ArrayList<AnnotationData>();
        for (Field field : instance.getClass().getDeclaredFields()) {
            annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            try {
                field.setAccessible(true);
                value = field.get(instance);
                keys = GenericInvoker.annotationToDataMap(annotation);
                collectedValues.add(new AnnotationData(annotation, keys, value, field.getName()));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("unable to check field ", e);
            }
        }
        for (AccessibleObject accessibleObject : instance.getClass().getDeclaredMethods()) {
            annotation = ((Method)accessibleObject).getAnnotation(annotationClass);
            if (annotation == null || ((Method)accessibleObject).getParameterCount() != 0) continue;
            try {
                ((Method)accessibleObject).setAccessible(true);
                value = ((Method)accessibleObject).invoke(instance, new Object[0]);
                keys = GenericInvoker.annotationToDataMap(annotation);
                collectedValues.add(new AnnotationData(annotation, keys, value, ((Method)accessibleObject).getName()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("unable to check method ", e);
            }
        }
        return collectedValues;
    }

    @NotNull
    private static <A extends Annotation> Map<String, Object> annotationToDataMap(A annotation) {
        HashMap keys = Maps.newHashMap();
        Arrays.stream(annotation.annotationType().getDeclaredMethods()).forEach(annMethod -> {
            String key = annMethod.getName();
            Object val = GenericInvoker.extractValueFromAnnotation(key, annotation);
            keys.put(key, val);
        });
        return keys;
    }

    private static <A extends Annotation> Object extractValueFromAnnotation(String methodName, A annotation) {
        try {
            Method method = annotation.getClass().getMethod(methodName, new Class[0]);
            return method.invoke(annotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("invalid method '" + methodName + "' for annotation" + String.valueOf(annotation.getClass()), e);
        }
    }
}

